% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callback_reg.R
\name{reg.callback_comp}
\alias{reg.callback_comp}
\title{Component model estimation}
\usage{
\method{reg}{callback_comp}(x, method = "fgls", ...)
}
\arguments{
\item{x}{a \code{callback_comp} object.}

\item{method}{estimation method, "ols" or "fgls" (the default).}

\item{...}{further arguments passed to or from other methods.}
}
\value{
a list with class \code{callback_reg} containing \code{"config"}
 for the definition of the estimation method and \code{"reg"} for the 
 estimation output.
 
The \code{"config"} data frame includes the following elements:
\itemize{
\item\bold{family: }"als" (for Asymptotic least squares).
\item\bold{method: }"ols" for Ordinary least square, or "fgls" for Feasible
generalized least squares.
\item\bold{model:}a components model.
}
The list \code{"reg"} includes the following elements (when relevant):
\itemize{
\item\bold{estim:}a data frame with \code{c_names} for the component names,
\code{coef}, the estimated coefficients, \code{std_coef}, the estimated 
standard errors, \code{student}the Student statistics for the equality of the 
coefficient to 0, \code{p_value}, the p-values of the asymptotic Student test. 
\item\bold{cova:} the estimated covariance matrix of the estimator.
\item\bold{over_test:}a data frame with the output of the overidentification 
test (FGLS only). The statistic is given by \code{stat}, the degrees of
freedom by \code{df} and the p-value by \code{p_value}.
}
}
\description{
Component model estimation
}
\examples{
model <- list(c("license"),c("woman"),c("woman","license","inter"))
comp <- callback_comp(data = mobility1, cluster = "offer", 
candid = c("gender","licenses"), callback = "callback", model = model)
reg(comp)
summary(reg(comp))

}
\references{
Duguet E., Le Gall R., L'Horty Y., Petit P. (2018). How does the labour 
market history influence the access to hiring interviews? International 
Journal of Manpower, 39(4), 519-533, doi: 10.1108/IJM-09-2017-0231.
}
