% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores.lda.R
\name{scores.lda}
\alias{scores.lda}
\title{Extract Observation Discriminant Scores for Linear Discriminant Analysis}
\usage{
\method{scores}{lda}(x, prior = x$prior, dimen, ...)
}
\arguments{
\item{x}{An object of class \code{"lda"} such as results from \code{\link[MASS:lda]{MASS::lda()}}}

\item{prior}{The prior probabilities of the classes. By default, taken to be the proportions in what was set
in the call to \code{\link[MASS:lda]{MASS::lda()}}}

\item{dimen}{The dimension of the space to be used. If this is less than the number of available dimensions,
\eqn{min(p, ng-1)}, only the first \code{dimen} discriminant components are used.}

\item{...}{Unused; for compatibility with the generic}
}
\value{
a data frame for the observations with columns \code{LD1}, \code{LD2}, ... for the discriminant dimensions
}
\description{
This is a thin wrapper for \code{\link[=predict_discrim]{predict_discrim()}} to provide a \code{scores()} method for discriminant analysis
from \code{\link[MASS:lda]{MASS::lda()}}.
}
\examples{
library(MASS)   # for lda()

iris.lda <- lda(Species ~ ., iris)
scores(iris.lda) |>
   str()
 
}
\seealso{
\code{\link[=predict_discrim]{predict_discrim()}}, \code{\link[MASS:lda]{MASS::lda()}}
}
\author{
Michael Friendly
}
