% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clinical_emissions.R
\name{clinical_theatre_emissions}
\alias{clinical_theatre_emissions}
\title{Clinical Emissions}
\usage{
clinical_theatre_emissions(
  wet_clinical_waste,
  wet_clinical_waste_unit = c("tonnes", "kg"),
  desflurane = 0,
  sevoflurane = 0,
  isoflurane = 0,
  methoxyflurane = 0,
  N2O = 0,
  propofol = 0,
  water_supply = 0,
  water_trt = TRUE,
  water_unit = c("cubic metres", "million litres"),
  electricity_kWh = 0,
  electricity_TD = TRUE,
  electricity_WTT = TRUE,
  heat_kWh = 0,
  heat_TD = TRUE,
  heat_WTT = TRUE,
  paper_use = stats::setNames(numeric(), character()),
  plastic_use = stats::setNames(numeric(), character()),
  metal_use = stats::setNames(numeric(), character()),
  electrical_use = stats::setNames(numeric(), character()),
  construction_use = stats::setNames(numeric(), character()),
  paper_waste = TRUE,
  plastic_waste = TRUE,
  metal_waste = TRUE,
  electrical_waste = TRUE,
  construction_waste = TRUE,
  paper_material_production = "Primary material production",
  metal_material_production = "Primary material production",
  construction_material_production = "Primary material production",
  paper_waste_disposal = c("Closed-loop", "Combustion", "Composting", "Landfill"),
  plastic_waste_disposal = c("Landfill", "Open-loop", "Closed-loop", "Combustion"),
  metal_waste_disposal = c("Closed-loop", "Combustion", "Landfill", "Open-loop"),
  electrical_waste_disposal = c("Landfill", "Open-loop"),
  construction_waste_disposal = c("Closed-loop", "Combustion", "Composting", "Landfill",
    "Open-loop"),
  value_col = c("value", "value_2024"),
  units = "kg",
  strict = TRUE
)
}
\arguments{
\item{wet_clinical_waste}{Numeric. Amount of (wet) clinical waste.}

\item{wet_clinical_waste_unit}{Unit for \code{wet_clinical_waste} (\code{"tonnes"} or \code{"kg"}).}

\item{desflurane}{Amount of desflurane used in KG (default: 0).}

\item{sevoflurane}{Amount of sevoflurane used in KG (default: 0).}

\item{isoflurane}{Amount of isoflurane used in KG (default: 0).}

\item{methoxyflurane}{Amount of methoxyflurane used in KG (default: 0).}

\item{N2O}{Amount of nitrous oxide (N2O) used in KG (default: 0).}

\item{propofol}{Amount of propofol used in KG (default: 0).}

\item{water_supply}{numeric, amount of water in the given unit.}

\item{water_trt}{logical, include treatment emissions (default TRUE).}

\item{water_unit}{"cubic metres" or "million litres".}

\item{electricity_kWh}{numeric kWh consumed.}

\item{electricity_TD}{logical, include T&D losses (default TRUE).}

\item{electricity_WTT}{logical, include WTT for electricity (default TRUE).}

\item{heat_kWh}{numeric kWh of heat/steam (onsite; excludes district).}

\item{heat_TD}{logical, include district heat distribution losses (default TRUE).}

\item{heat_WTT}{logical, include WTT for heat/steam (default TRUE).}

\item{paper_use, plastic_use, metal_use, electrical_use, construction_use}{Named numeric vectors (tonnes) for each material family (see \strong{Material vectors} above).}

\item{paper_waste, plastic_waste, metal_waste, electrical_waste, construction_waste}{Logical. If \code{TRUE}, the same tonnage as the corresponding \verb{*_use} is routed to waste
treatment using the family’s \verb{*_waste_disposal} choice. Default \code{TRUE}.}

\item{paper_material_production, metal_material_production, construction_material_production}{Column Text choice for \strong{material-use} factors (typically \code{"Primary material production"}).}

\item{paper_waste_disposal, plastic_waste_disposal, metal_waste_disposal, electrical_waste_disposal, construction_waste_disposal}{Disposal route to use for that family (see \code{\link[=material_emissions]{material_emissions()}} for allowed values).}

\item{value_col}{Which \code{uk_gov_data} column to use: \code{"value"} or \code{"value_2024"}. Default \code{"value"}.}

\item{units}{Output units: \code{"kg"} (default) or \code{"tonnes"}.}

\item{strict}{Logical. If \code{TRUE}, missing factors error inside delegated functions; if \code{FALSE}, treat as 0. Default \code{TRUE}.}
}
\value{
Total CO2e in the units specified by \code{units} (kg or tonnes).
}
\description{
Calculate CO2e from an operating theatre session by summing:
(1) wet clinical waste; (2) building use (water/electricity/heat);
(3) material purchases + end-of-life (paper, plastics, metal, electrical, construction);
(4) anaesthetic agents.
}
\details{
Wet clinical waste factor defaults to 0.879 tCO2e per tonne (NGA 2022).
Building emissions are computed via \code{\link[=building_emissions]{building_emissions()}} with \code{units = "kg"}.
Materials are computed via \code{\link[=material_emissions]{material_emissions()}} with \code{units = "kg"}.
Anaesthetic emissions are computed via \code{\link[=anaesthetic_emissions]{anaesthetic_emissions()}} (tonnes) and converted to kg to sum.
The function sums all components in kg and returns in the \code{units} requested.
}
\section{Inputs – Material vectors}{

For each material family, pass a \strong{named numeric vector} of tonnages (in tonnes).
Names must be canonical keys (case/space/punctuation is normalised internally, but
using the canonical forms below is recommended):
\itemize{
\item \strong{Paper} \code{paper_use}: \code{board}, \code{mixed}, \code{paper}
\item \strong{Plastics} \code{plastic_use}: \code{average}, \code{average_film}, \code{average_rigid},
\code{hdpe}, \code{ldpe}, \code{lldpe}, \code{pet}, \code{pp}, \code{ps}, \code{pvc}
\item \strong{Metal} \code{metal_use}: use your package’s canonical metal keys
(e.g. \code{aluminium_cans}, \code{aluminium_foil}, \code{mixed_cans}, \code{scrap}, \code{steel_cans})
\item \strong{Electrical} \code{electrical_use}: \code{fridges}, \code{freezers}, \code{large_electrical},
\code{it}, \code{small_electrical}, \code{alkaline_batteries}, \code{liion_batteries}, \code{nimh_batteries}
\item \strong{Construction} \code{construction_use}: e.g. \code{aggregates}, \code{average}, \code{asbestos},
\code{asphalt}, \code{bricks}, \code{concrete}, \code{insulation}, \code{metals}, \code{soils}, \code{mineral_oil},
\code{plasterboard}, \code{tyres}, \code{wood}
}

For each family you can also set a single \strong{waste toggle} (e.g. \code{plastic_waste = TRUE})
to send the same tonnage to a single disposal route (e.g. \code{plastic_waste_disposal = "Landfill"}).
}

\examples{
\donttest{
# Minimal example using vector-first materials
clinical_theatre_emissions(
  wet_clinical_waste = 100, wet_clinical_waste_unit = "kg",

  # Building (kWh)
  electricity_kWh = 250, heat_kWh = 120,

  # Materials: paper/plastic/metal/electrical/construction
  paper_use = c(paper = 20),
  paper_waste = TRUE, paper_waste_disposal = "Closed-loop",

  plastic_use = c(pet = 10),
  plastic_waste = TRUE, plastic_waste_disposal = "Landfill",

  metal_use = c(steel_cans = 0.2),
  metal_waste = TRUE, metal_waste_disposal = "Open-loop",

  electrical_use = c(alkaline_batteries = 0.05),
  electrical_waste = TRUE, electrical_waste_disposal = "Open-loop",

  construction_use = c(concrete = 1),
  construction_waste = FALSE,

  value_col = "value",
  units = "kg"
)
}
}
