% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/electrical_emissions.R
\name{electrical_emissions}
\alias{electrical_emissions}
\title{Electrical emissions}
\usage{
electrical_emissions(
  use = stats::setNames(numeric(), character()),
  waste = TRUE,
  material_production = "Primary material production",
  waste_disposal = c("Landfill", "Open-loop"),
  units = c("kg", "tonnes"),
  value_col = c("value", "value_2024"),
  strict = TRUE
)
}
\arguments{
\item{use}{Named numeric vector of quantities in tonnes.
Canonical names supported:
\code{fridges}, \code{freezers}, \code{large_electrical}, \code{it}, \code{small_electrical},
\code{alkaline_batteries}, \code{liion_batteries}, \code{nimh_batteries}.
Aliases accepted (case/punct-insensitive), e.g. \code{"fridge"}, \code{"freezer"},
\code{"large"}, \code{"it equipment"}, \code{"small"}, \code{"alkaline"}, \code{"liion"}, \code{"ni mh"},
Unknown names warn and are ignored.}

\item{waste}{Logical. If \code{TRUE}, waste tonnages equal \code{use}. If \code{FALSE}, no waste.}

\item{material_production}{Either a single string for all items
(e.g., \code{"Primary material production"}) or a named vector per item.
Synonyms accepted: \code{"primary"}, \code{"closed loop"}, etc. (If a chosen option is
absent in the table, behaviour depends on \code{strict}.)}

\item{waste_disposal}{One of \code{"Landfill"} or \code{"Open-loop"}. Applied to all waste.}

\item{units}{Output units: \code{"kg"} (default) or \code{"tonnes"}.}

\item{value_col}{Which numeric column to use: \code{"value"} or \code{"value_2024"}.}

\item{strict}{If \code{TRUE} (default), error when any nonzero \code{use}/waste needs a
factor missing from the table. If \code{FALSE}, treat missing factors as \code{0}.}
}
\value{
Numeric total emissions in requested \code{units}.
}
\description{
Computes embodied GHG emissions for electrical items using \code{uk_gov_data} rows with
Level 2 = "Electrical items". Material-use factors come from
\verb{Level 1 = "Material use", Column Text = material_production} (your table
currently provides Primary material production only). Waste factors come
from \verb{Level 1 = "Waste disposal", Column Text = waste_disposal}.
Factors are kg CO2e per tonne.
}
\examples{
# Primary production + landfill; waste = use
electrical_emissions(
  use = c(fridges = 1, freezers = 0.5, large_electrical = 0.2),
  waste_disposal = "Landfill",
  waste = TRUE,
  units = "kg"
)

# 2024 factors, no waste, report in tonnes
electrical_emissions(
  use = c(it = 0.01, liion_batteries = 0.002),
  value_col = "value_2024",
  waste = FALSE,
  units = "tonnes"
)
}
