% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plastic_emissions.R
\name{plastic_emissions}
\alias{plastic_emissions}
\title{Calculate plastic emissions}
\usage{
plastic_emissions(
  use = stats::setNames(numeric(), character()),
  waste = TRUE,
  waste_disposal = c("Landfill", "Open-loop", "Closed-loop", "Combustion"),
  units = c("kg", "tonnes"),
  value_col = c("value", "value_2024"),
  strict = TRUE
)
}
\arguments{
\item{use}{Named numeric vector of plastic quantities in tonnes.
Names are matched (case/space/punctuation-insensitive) to \verb{Level 3}
after normalisation that also:
\enumerate{
\item removes any prefix up to \code{": "} (e.g., \code{"Plastics: HDPE"} is \code{"HDPE"}), and
\item strips any trailing parenthetical (e.g., \code{"HDPE (bottles)"} is \code{"HDPE"}).
Accepted types: \code{average}, \code{average_film}, \code{average_rigid},
\code{hdpe}, \code{ldpe}, \code{lldpe}, \code{pet}, \code{pp}, \code{ps}, \code{pvc}.
Unknown names are ignored (treated as zero).
}}

\item{waste}{Logical. If \code{TRUE}, the same tonnages as \code{use} are sent to the
chosen waste route. If \code{FALSE}, no waste is applied.}

\item{waste_disposal}{One of \code{"Landfill"}, \code{"Open-loop"}, \code{"Closed-loop"},
or \code{"Combustion"}. Applied to all waste. If a plastic lacks a factor for the
chosen route, behaviour depends on \code{strict}.}

\item{units}{Output units: \code{"kg"} (default) or \code{"tonnes"}.}

\item{value_col}{Which numeric column to use in \code{uk_gov_data}: \code{"value"} or \code{"value_2024"}.}

\item{strict}{If \code{TRUE} (default), error when any nonzero \code{use} or implied
\code{waste} requires a factor that is absent in the table. If \code{FALSE}, treat
missing factors as zero.}
}
\value{
Numeric total emissions in requested \code{units}.
}
\description{
Computes embodied GHG emissions for plastics using \code{uk_gov_data} rows with
Level 2 = "Plastic". Material-use factors come from
\verb{Level 1 = "Material use", Column Text = "Primary material production"}.
Waste factors come from \verb{Level 1 = "Waste disposal", Column Text = waste_disposal}.
Factors are assumed kg CO2e per tonne (\code{UOM = tonne}, \verb{GHG/Unit = kg CO2e}).
}
\details{
Material use: Plastics generally use \code{"Primary material production"}
as the \verb{Column Text}. This function always uses that for material-use factors.

Waste disposal: Factors are taken from the specified \code{waste_disposal}
route. Availability varies by plastic type and year; this is enforced by the
presence/absence of rows in \code{uk_gov_data}. Missing pairs error under
\code{strict = TRUE} or contribute zero under \code{strict = FALSE}.

Units: Factors are kg CO2e per tonne; if \code{units = "tonnes"}, the total is
divided by 1000.
}
\examples{
# 1) Basic: primary material production + landfill; waste tonnage = use
plastic_emissions(
  use = c(average_plastics = 100, hdpe = 50, pet = 25),  # tonnes
  waste_disposal = "Landfill",
  waste = TRUE,
  units = "kg"
)

# 2) Choose 2024 factors and report in tonnes; no waste applied
plastic_emissions(
  use = c(average_plastic_film = 10, average_plastic_rigid = 5, pp = 2),
  waste_disposal = "Closed-loop",
  waste = FALSE,
  value_col = "value_2024",
  units = "tonnes"
)

# 3) Strict behaviour: error if a required waste route is unavailable
\dontrun{
plastic_emissions(
  use = c(ps = 1),
  waste_disposal = "Combustion",
  waste = TRUE,
  strict = TRUE
)}
# Tolerant: treat missing waste factors as 0
plastic_emissions(
  use = c(ps = 1),
  waste_disposal = "Combustion",
  waste = TRUE,
  strict = FALSE
)
}
