% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gap-all.R
\name{gap_all}
\alias{gap_all}
\alias{gap_horizontal}
\alias{gap_vertical}
\title{Grid and flex margins}
\usage{
gap_all(x, ...)

gap_horizontal(x, ...)

gap_vertical(x, ...)
}
\arguments{
\item{x}{A tag element or \link{.style} pronoun.}

\item{...}{A number specifying the space between child elements. One of,
\itemize{
\item \code{0}
\item \code{1}
\item \code{2}
\item \code{3}
\item \code{4}
\item \code{5}

Use name-value pairs to specify \link{breakpoints}.
}}
}
\value{
An object of the same type as \code{x}.
}
\description{
The \verb{gap_*()} functions adjust the margins of child elements of a tag element
with a grid or flex display. Instead of applying \link[=margin_all]{margin_*()} to
each child element, a single \verb{gap_*()} function is applied to the parent element.
}
\examples{

library(htmltools)

div(
  .style \%>\%
    flex_display(),
  div(
    .style \%>\%
      margin_all(2)
  ),
  div(
    .style \%>\%
      margin_all(2)
  )
)

div(
  .style \%>\%
    flex_display() \%>\%
    gap_all(2),
  div(),
  div()
)

}
\seealso{
\code{\link[=margin_all]{margin_all()}} for margins on non flex item elements.
}
