% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item-fill.R
\name{item_fill}
\alias{item_fill}
\title{Flex fill}
\usage{
item_fill(x, ...)
}
\arguments{
\item{x}{\code{param_subject()}}

\item{...}{A boolean specifying to fill. One of
\itemize{
\item \code{TRUE}
}

Use name-value pairs to specifying \link{breakpoints}.}
}
\value{
An object of the same type as \code{x}.
}
\description{
The \code{item_fill()} adjusts how tag elements fill a flex element.
}
\examples{

library(htmltools)

div(
  .style \%>\%
    flex_display(),
  div(
    .style \%>\%
      item_fill(TRUE),
    "Flex item"
  ),
  div(
    .style \%>\%
      item_fill(TRUE),
    "Flex item"
  ),
  div(
    .style \%>\%
      item_fill(TRUE),
    "Flex item"
  )
)

}
\seealso{
Other flex utilities: 
\code{\link{flex_align}()},
\code{\link{flex_content}()},
\code{\link{flex_direction}()},
\code{\link{flex_display}()},
\code{\link{flex_justify}()},
\code{\link{flex_wrap}()},
\code{\link{item_align}()},
\code{\link{item_grow}()},
\code{\link{item_order}()}
}
\concept{flex utilities}
