% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Common.R
\name{dtnorm}
\alias{dtnorm}
\alias{ptnorm}
\alias{qtnorm}
\alias{rtnorm}
\title{Density function of Truncated Normal Distribution}
\usage{
dtnorm(x, mean, sd, min = 0, max = 1e+09)

ptnorm(q, mean, sd, min = 0, max = 1e+09)

qtnorm(p, mean, sd, min = 0, max = 1e+09)

rtnorm(n, mean, sd, min = 0, max = 1e+09)
}
\arguments{
\item{x}{Value of the variable after deductible and limit max(0,min(claim,limit)-deductible)}

\item{mean}{Mean of the untruncated Normal distribution}

\item{sd}{Standard deviation of the untruncated Normal distribution}

\item{min}{Left truncation (like deductible)}

\item{max}{Right truncation (like limit)}

\item{q}{Value of the variable after deductible and limit max(0,min(claim,limit)-deductible)}

\item{p}{Value of the probability}

\item{n}{Number of samples}
}
\description{
Density function of Truncated Normal Distribution

Cumulative probability function of Truncated Normal Distribution

Quantile function of Truncated Normal Distribution max(0,min(claim,limit)-deductible)

Random generation of Truncated Normal Distribution max(0,min(claim,limit)-deductible)
}
\examples{
dtnorm(0.5,1,2)
ptnorm(0.5,1,2)
qtnorm(0.5,1,2)
rtnorm(100,1,2)
}
