% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\name{compare}
\alias{compare}
\title{Compare predictions and labels}
\usage{
compare(
  predictions,
  labels,
  partition = TRUE,
  names = c(specificity = 0, sensitivity = 1)
)
}
\arguments{
\item{predictions}{(numeric | character) \cr vector of class predictions, class and unique values+
need to match those of \code{labels}.}

\item{labels}{(numeric | character) \cr vector of true class labels (reference standard)}

\item{partition}{(logical) \cr should result be split into one matrix per class (TRUE; default) or not (FALSE)}

\item{names}{(character | NULL) \cr named character. Values specify data values, names specify class names.
If \code{names=NULL}, the values and names are defined as \code{unique(labels)}}
}
\value{
(list | matrix) \cr list of matrices (one for each unique value of \code{labels}) with
values 1 (correct prediction) and 0 (false prediction).
If \code{partition=TRUE}, the matrices are combined in a single matrix with \code{rbind}.
}
\description{
Compare predictions and labels
}
\examples{
pred <- matrix(c(1, 1, 0), 5, 3)
labels <- c(1, 1, 0, 0, 1)
compare(pred, labels, FALSE)
compare(pred, labels, TRUE)
}
