% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format-mermaid.R
\name{write_mermaid}
\alias{write_mermaid}
\title{Write caugi Graph to Mermaid File}
\usage{
write_mermaid(x, file, ...)
}
\arguments{
\item{x}{A \code{caugi} object.}

\item{file}{Path to output file.}

\item{...}{Additional arguments passed to \code{\link[=to_mermaid]{to_mermaid()}}, such as
\code{direction}.}
}
\value{
Invisibly returns the path to the file.
}
\description{
Writes a caugi graph to a file in Mermaid format.
}
\examples{
cg <- caugi(
  A \%-->\% B + C,
  B \%-->\% D,
  C \%-->\% D,
  class = "DAG"
)

\dontrun{
# Write to file
write_mermaid(cg, "graph.mmd")

# With custom direction
write_mermaid(cg, "graph.mmd", direction = "LR")
}

}
\seealso{
Other export: 
\code{\link{caugi_deserialize}()},
\code{\link{caugi_dot}()},
\code{\link{caugi_export}()},
\code{\link{caugi_graphml}()},
\code{\link{caugi_mermaid}()},
\code{\link{caugi_serialize}()},
\code{\link{export-classes}},
\code{\link{format-caugi}},
\code{\link{format-dot}},
\code{\link{format-graphml}},
\code{\link{format-mermaid}},
\code{\link{knit_print.caugi_export}},
\code{\link{read_caugi}()},
\code{\link{read_graphml}()},
\code{\link{to_dot}()},
\code{\link{to_graphml}()},
\code{\link{to_mermaid}()},
\code{\link{write_caugi}()},
\code{\link{write_dot}()},
\code{\link{write_graphml}()}
}
\concept{export}
