% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cbs_download_data.R
\name{cbs_download_data}
\alias{cbs_download_data}
\title{Gets all data from a cbs table.}
\usage{
cbs_download_data(
  id,
  path = file.path(id, "data.csv"),
  catalog = "CBS",
  ...,
  select = NULL,
  typed = TRUE,
  verbose = FALSE,
  show_progress = interactive() && !verbose,
  base_url = getOption("cbsodataR.base_url", BASE_URL)
)
}
\arguments{
\item{id}{of cbs open data table}

\item{path}{of data file, defaults to "id/data.csv"}

\item{catalog}{catalog id, can be retrieved with \code{\link[=cbs_get_datasets]{cbs_get_datasets()}}}

\item{...}{optional filter statements to select rows of the data,}

\item{select}{optional names of columns to be returned.}

\item{typed}{Should the data automatically be converted into integer and numeric?}

\item{verbose}{show the underlying downloading of the data}

\item{show_progress}{show a progress bar while downloading.}

\item{base_url}{optionally specify a different server. Useful for
third party data services implementing the same protocol. See details.}
}
\description{
Gets all data via bulk download. \code{cbs_download_data} dumps the data in
(international) csv format.
}
\section{Specify different server}{


Besides the official CBS data, there are also third party and preview dataservices
implementing the same protocol. The \code{base_url} parameter allows to specify a different server.
The \code{base_url} can either be specified explicitly or set globally with with
\code{options(cbsodataR.base_url = "http://example.com")}.
Some further tweaking may be necessary for third party services, a download url
is constructed using: either with:
\itemize{
\item \verb{<base_url>/<BULK>/<id>/...} for data
\item \verb{<base_url>/<API>/<id>/?$format=json} for metadata
}

Default values for \code{BASEURL}, \code{BULK} and \code{API} are set in the package options,
but can be changed with:

\if{html}{\out{<div class="sourceCode">}}\preformatted{options(
 cbsodataR.base_url = "https://opendata.cbs.nl",
 cbsodataR.BULK = "ODataFeed/odata",
 cbsodataR.API = "ODataAPI/odata"
)
}\if{html}{\out{</div>}}

which are the default values set in the package.
}

\seealso{
Other download: 
\code{\link{cbs_download_meta}()},
\code{\link{cbs_download_table}()}

Other data retrieval: 
\code{\link{cbs_add_date_column}()},
\code{\link{cbs_add_label_columns}()},
\code{\link{cbs_add_unit_column}()},
\code{\link{cbs_extract_table_id}()},
\code{\link{cbs_get_data}()},
\code{\link{cbs_get_data_from_link}()}
}
\concept{data retrieval}
\concept{download}
