% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemical-APIs-batch.R
\name{get_lists_containing_chemical_batch}
\alias{get_lists_containing_chemical_batch}
\title{Get chemical lists containing given chemical batch}
\usage{
get_lists_containing_chemical_batch(
  chemical_list = NULL,
  API_key = NULL,
  rate_limit = 0L,
  verbose = FALSE
)
}
\arguments{
\item{chemical_list}{A list of the chemical identifier DTXSIDs.}

\item{API_key}{The user-specific API key.}

\item{rate_limit}{Number of seconds to wait between each request}

\item{verbose}{A logical indicating if some “progress report” should be given.}
}
\value{
A named list of chemical lists that contain the given chemicals.
}
\description{
Get chemical lists containing given chemical batch
}
\examples{
\dontshow{if (has_ctx_key() & is.na(ctx_key() == 'FAKE_KEY')) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Pull lists containing chemicals for multiple chemicals
lists <- get_lists_containing_chemical_batch(chemical_list = c('DTXSID7020182',
                                                               'DTXSID2021315'))
\dontshow{\}) # examplesIf}
}
