% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cont_conv.R
\name{cont_conv}
\alias{cont_conv}
\title{Continuous convolution}
\usage{
cont_conv(x, theta = 0, nu = 5, quasi = TRUE)
}
\arguments{
\item{x}{data; numeric matrix or data frame.}

\item{theta}{scale parameter of the USB distribution (see, \code{\link[=dusb]{dusb()}}).}

\item{nu}{smoothness parameter of the USB distribution (see, \code{\link[=dusb]{dusb()}}). The
estimator uses the Epanechnikov kernel for smoothing and the USB for
continuous convolution (default parameters correspond to the \eqn{U[-0.5,
  0.5]} distribution).}

\item{quasi}{logical indicating whether quasi random numbers sholuld be used
(\code{\link[qrng:qrng]{qrng::ghalton()}}); only works for \code{theta = 0}.}
}
\value{
A data frame with noise added to each discrete variable (ordered
columns).
}
\description{
Applies the continuous convolution trick, i.e. adding continuous noise to all
discrete variables. If a variable should be treated as discrete, declare it
as \code{\link[=ordered]{ordered()}} (passed to \code{\link[=expand_as_numeric]{expand_as_numeric()}}).
}
\details{
The UPSB distribution (\code{\link[=dusb]{dusb()}}) is used as the noise distribution.
Discrete variables are assumed to be integer-valued.
}
\examples{
# dummy data with discrete variables
dat <- data.frame(
    F1 = factor(rbinom(10, 4, 0.1), 0:4),
    Z1 = ordered(rbinom(10, 5, 0.5), 0:5),
    Z2 = ordered(rpois(10, 1), 0:10),
    X1 = rnorm(10),
    X2 = rexp(10)
)

pairs(dat)
pairs(expand_as_numeric(dat))  # expanded variables without noise
pairs(cont_conv(dat))          # continuously convoluted data

}
\references{
Nagler, T. (2017). \emph{A generic approach to nonparametric function
estimation with mixed data.} \href{https://arxiv.org/pdf/1704.07457}{arXiv:1704.07457}
}
