% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lib_funtions.R
\name{TreeGraph}
\alias{TreeGraph}
\title{TreeGraph}
\usage{
TreeGraph(tree, solution = list(), name = c(), range.color = 1)
}
\arguments{
\item{tree}{Event.tree S4 object}

\item{solution}{list with two components:
\itemize{
\item numeric - score associated with a level
\item list of vectors - stage structure
}}

\item{name}{vector of strings  - variable names}

\item{range.color}{(numeric) - it chooses the palette. If 1, it is used a 8-color palette.
If 2, it is used a 501-color palette.}
}
\value{
list: \itemize{
 \item  $node - node attributes
 \itemize{
   \item $node$nodes (vector) - set of situations.
   \item node$label (vector) - it identifies the variable asscoiated with
       each position.
   \item node$color (vector) - color of each situation. All situations
       coincident with a stage are depicted in black.
   }
 \item $edge - edge attributes
 \itemize{
   \item $edge$edges (list) - set of list that emanates from each situation.
   \item edge$label (vector) - edge labels.
   }
 }
}
\description{
A function to produce the data structure needed to plot Event and Staged
trees using \pkg{RGraphviz}.
}
