% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/muaidsCalculate.R
\name{muaidsCalculate}
\alias{muaidsCalculate}
\title{Calculate the demand share equations of a AI or QUAI demand system, including demographic variable, using point estimates (e.g., mean, median, percentiles).}
\usage{
muaidsCalculate(
  muPrices = numeric(),
  muBudget = numeric(),
  muDemographics = numeric(),
  Params = matrix(),
  quaids = FALSE,
  m = numeric(),
  t = numeric(),
  dems = FALSE
)
}
\arguments{
\item{muPrices}{A matrix of logged muPrices with (1xm) dimensions where n is the number of observations and m the number of shares.}

\item{muBudget}{A matrix of logged total expenditure/muBudget with (1x1) dimensions where n is the number of observations.}

\item{muDemographics}{A matrix of demographic variables with (1xt) dimensions where n is the number of observations and t the number of demographic variables.}

\item{Params}{A vector containing the parameters alpha, beta, gamma, and theta and lambda if elected.}

\item{quaids}{Logical. Should quadratic form be used instead?}

\item{m}{Number of shares.}

\item{t}{Number of demographic variables.}

\item{dems}{Bolean. Should demographic variables be included?}
}
\value{
A matrix of estimated shares with (1xm) dimensions where n is the number of observations and m the number of shares.
}
\description{
Calculate the demand share equations of a AI or QUAI demand system, including demographic variable, using point estimates (e.g., mean, median, percentiles).
}
