% Generated by roxygen2 (4.0.2): do not edit by hand
\name{closeness.latora}
\alias{closeness.latora}
\title{Find the variant (Latora) closeness centrality in a disconnected graph}
\usage{
closeness.latora(graph, vids = V(graph), mode = c("all", "out", "in"),
  weights = NULL, normalized = FALSE)
}
\arguments{
\item{graph}{The input graph as igraph object}

\item{vids}{Vertex sequence, the vertices for which the centrality values are returned. Default is all vertices.}

\item{mode}{Character constant, gives whether the shortest paths to or from the given vertices should be calculated for directed graphs. If out then the shortest paths from the vertex, if in then to it will be considered. If all, the default, then the corresponding undirected graph will be used, ie. not directed paths are searched. This argument is ignored for undirected graphs.}

\item{weights}{Possibly a numeric vector giving edge weights. If this is NULL, the default, and the graph has a weight edge attribute, then the attribute is used. If this is NA then no weights are used (even if the graph has a weight attribute).}

\item{normalized}{Logical scalar, whether to calculate the normalized score.}
}
\value{
A numeric vector contaning the centrality scores for the selected vertices.
}
\description{
Variant (Latora) closeness centrality defined as:
\deqn{\sum_{i \neq v}\frac{1}{d(v,i)}}{sum(1/d(v,i), i != v)}
}
\details{
This variant (sum of inversed distances to all other nodes instead of the inversed of the sum of distances to all other nodes) applicable to both connected and unconnected graphs. \cr
More detail at \href{http://www.centiserver.org/?q1=centrality&q2=Closeness_Centrality}{Closeness Centrality}
}
\examples{
g <- graph(c(1,2,2,3,3,4,4,2))
closeness.latora(g)
}
\author{
Mahdi Jalili \email{m_jalili@farabi.tums.ac.ir}
}
\references{
Latora V., Marchiori M., Efficient behavior of small-world networks, Physical Review Letters, V. 87, p. 19, 2001.

Opsahl, Tore, Filip Agneessens, and John Skvoretz. "Node centrality in weighted networks: Generalizing degree and shortest paths." Social Networks 32.3 (2010): 245-251.
}

