% Generated by roxygen2 (4.0.2): do not edit by hand
\name{salsa}
\alias{salsa}
\title{Find the SALSA as 'hub' or 'authority' score}
\usage{
salsa(graph, vids = V(graph), score = c("hub", "authority"))
}
\arguments{
\item{graph}{The input graph as igraph object}

\item{vids}{Vertex sequence, the vertices for which the centrality values are returned. Default is all vertices.}

\item{score}{Character constant, gives which score should be calculated and must be one of 'hub' or 'authority'. The default is 'hub'.}
}
\value{
A numeric vector contaning the centrality scores for the selected vertices.
}
\description{
The Stochastic Approach for Link-Structure Analysis (SALSA) is combination of HITS and PageRank which creates a neighborhood graph using authority and hub pages and links and create a bipartite graph of the authority and hub pages in the neighborhood graph.
}
\details{
More detail at \href{http://www.centiserver.org/?q1=centrality&q2=SALSA}{SALSA}
}
\examples{
g <- barabasi.game(10)
salsa(g)
}
\author{
Mahdi Jalili \email{m_jalili@farabi.tums.ac.ir}
}
\references{
Lempel, Ronny, and Shlomo Moran. "SALSA: the stochastic approach for link-structure analysis." ACM Transactions on Information Systems (TOIS) 19.2 (2001): 131-160.
}

