% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VAR.R
\name{DP.VAR1}
\alias{DP.VAR1}
\title{Dynamic programming for VAR1 change points detection through \eqn{l_0} penalty.}
\usage{
DP.VAR1(X_futu, X_curr, gamma, lambda, delta, eps = 0.001)
}
\arguments{
\item{X_futu}{A \code{numeric} matrix of time series at one step ahead, with horizontal axis being time.}

\item{X_curr}{A \code{numeric} matrix of time series at current step, with horizontal axis being time.}

\item{gamma}{A \code{numeric} scalar of the tuning parameter associated with \eqn{l_0} penalty.}

\item{lambda}{A \code{numeric} scalar of the tuning parameter for lasso penalty.}

\item{delta}{A strictly \code{integer} scalar of minimum spacing.}

\item{eps}{A \code{numeric} scalar of precision level for convergence of lasso.}
}
\value{
An object of \code{\link[base]{class}} "DP", which is a \code{list} with the following structure:
 \item{partition}{A vector of the best partition.}
 \item{cpt}{A vector of change points estimation.}
}
\description{
Perform dynamic programming for VAR1 change points detection through \eqn{l_0} penalty.
}
\examples{
p = 10
sigma = 1
n = 20
v1 = 2*(seq(1,p,1)\%\%2) - 1
v2 = -v1
AA = matrix(0, nrow = p, ncol = p-2)
A1 = cbind(v1,v2,AA)*0.1
A2 = cbind(v2,v1,AA)*0.1
A3 = A1
data = simu.VAR1(sigma, p, 2*n+1, A1)
data = cbind(data, simu.VAR1(sigma, p, 2*n, A2, vzero=c(data[,ncol(data)])))
data = cbind(data, simu.VAR1(sigma, p, 2*n, A3, vzero=c(data[,ncol(data)])))
N = ncol(data)
X_curr = data[,1:(N-1)]
X_futu = data[,2:N]
DP_result = DP.VAR1(X_futu, X_curr, gamma = 1, lambda = 1, delta = 5)
DP_result$cpt
}
\references{
Wang, Yu, Rinaldo and Willett (2019) <arxiv:1909.06359>
}
\author{
Daren Wang & Haotian Xu
}
