% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-typechecks.R
\name{validate_logical_vec}
\alias{validate_logical_vec}
\title{Validate a Logical Vector}
\usage{
validate_logical_vec(logical_vec)
}
\arguments{
\item{logical_vec}{Logical vector to validate.}
}
\value{
\code{TRUE} if the logical vector is valid, otherwise it throws an
error.
}
\description{
Validates a logical vector to ensure it meets specific criteria:
\itemize{
\item Must have a length of at least 1.
\item Must be a logical-type vector.
\item If all values are NA, it will raise a warning.
}
}
\examples{
validate_logical_vec(c(TRUE, FALSE, TRUE)) # TRUE
try(validate_logical_vec(c())) # Error
validate_logical_vec(c(NA, NA)) # Warning
}
\seealso{
\code{\link{is_proportion}}, \code{\link{is_count}},
\code{\link{validate_proportion}}, \code{\link{validate_count}}
}
