% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optk_gcms.R
\name{optk_gcms}
\alias{optk_gcms}
\title{Optimize the number of clusters for a dataset}
\usage{
optk_gcms(
  s,
  var_names = c("bio_1", "bio_12"),
  study_area = NULL,
  cluster = "kmeans",
  method = "wss",
  n = NULL,
  nstart = 10,
  K.max = 10,
  B = 100
)
}
\arguments{
\item{s}{A list of stacks of General Circulation Models.}

\item{var_names}{Character. A vector with the names of the variables to compare OR 'all'.}

\item{study_area}{Extent object, or any object from which an Extent object can be extracted. An object that defines the study area for cropping and masking the rasters.}

\item{cluster}{A character string specifying the method to build the clusters. Options are 'kmeans' (default) or 'hclust'.}

\item{method}{A character string specifying the method to use for determining the optimal number of clusters. Options are 'wss' for within-cluster sum of squares, 'silhouette' for average silhouette width, and 'gap_stat' for the gap statistic method. Default is 'wss'.}

\item{n}{An integer specifying the number of randomly selected samples to use in the clustering analysis. If NULL (default), all data is used.}

\item{nstart}{Numeric. The number of random sets to be chosen. Default is 10. Argument is passed to `stats::kmeans()`.}

\item{K.max}{Numeric. The maximum number of clusters to consider. Default is 10. Argument is passed to `factoextra::fviz_nbclust()`.}

\item{B}{Integer. The number of Monte Carlo (“bootstrap”) samples. Default is 100. Argument is passed to `cluster::clusGap()`.}
}
\value{
A ggplot object representing the optimal number of clusters.
}
\description{
This function performs clustering analysis on a dataset and determines the optimal number of clusters based on a specified method.
}
\examples{
var_names <- c("bio_1", "bio_12")
s <- import_gcms(system.file("extdata", package = "chooseGCM"), var_names = var_names)[1:5]
study_area <- terra::ext(c(-80, -70, -50, -40)) |>
  terra::vect(crs="+proj=longlat +datum=WGS84 +no_defs")
optk_gcms(s, var_names, study_area)

}
\seealso{
\code{\link{transform_gcms}} \code{\link{flatten_gcms}}
}
\author{
Luíz Fernando Esser (luizesser@gmail.com)
https://luizfesser.wordpress.com
}
