% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scorers.R
\name{BNLearnScorer}
\alias{BNLearnScorer}
\title{BNLearnScorer}
\usage{
BNLearnScorer(node, parents, ...)
}
\arguments{
\item{node}{Name of node to score.}

\item{parents}{The parents of node.}

\item{...}{The ellipsis is used to pass other parameters to the scorer.}
}
\value{
A numeric value representing the log score of the node given the
parents.
}
\description{
A thin wrapper on the bnlearn::score function.
}
\examples{
data <- bnlearn::learning.test
BNLearnScorer('A', c('B', 'C'), data = data)
BNLearnScorer('A', c(), data = data)
BNLearnScorer('A', vector(), data = data)
BNLearnScorer('A', NULL, data = data)
BNLearnScorer('A', c('B', 'C'), data = data, type = "bde", iss = 100)
BNLearnScorer('A', c('B', 'C'), data = data, type = "bde", iss = 1)

}
