% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/default_proposal.R
\name{DefaultProposal}
\alias{DefaultProposal}
\title{Default proposal constructor}
\usage{
DefaultProposal(p = c(0.33, 0.33, 0.165, 0.165, 0.01), verbose = TRUE)
}
\arguments{
\item{p}{Probability for each proposal in the order (split_join, node_move,
swap_node, swap_adjacent, stay_still).}

\item{verbose}{Boolean flag to record proposal used.}
}
\value{
A function corresponding to the default proposal.
}
\description{
This constructs a proposal function for PartitionMCMC.
}
\examples{
data <- bnlearn::learning.test

dag <- UniformlySampleDAG(colnames(data))
partitioned_nodes <- DAGtoPartition(dag)

scorer <- CreateScorer(
  scorer = BNLearnScorer, 
  data = data
  )

results <- SampleChains(10, partitioned_nodes, 
                        PartitionMCMC(
                          proposal = DefaultProposal(p = c(0.0, 1.0, 0.0, 0.0, 0.0))
                          ), 
                        scorer)

}
