% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post_predict.R
\name{SamplePosteriorPredictiveChains}
\alias{SamplePosteriorPredictiveChains}
\title{Draw from a posterior predictive distribution}
\usage{
SamplePosteriorPredictiveChains(x, p_predict, ...)
}
\arguments{
\item{x}{A cia_chain(s) object.}

\item{p_predict}{A function that draws from the posterior predictive distribution
of interest given an adjacency matrix representing a DAG. The function must
be of the form p_predict(dag, ...) and return either a vector of numeric values.}

\item{...}{Parameters to be passed to p_predict.}
}
\value{
A cia_post_chain(s) object.
}
\description{
Simulate samples from a posterior predictive distribution for a feature \eqn{f(g)}
a graph \eqn{g}.
}
\examples{
data <- bnlearn::learning.test

dag <- UniformlySampleDAG(colnames(data))
partitioned_nodes <- DAGtoPartition(dag)

scorer <- CreateScorer(
  scorer = BNLearnScorer,
  data = data
  )

results <- SampleChains(10, partitioned_nodes, PartitionMCMC(), scorer)
dag_chains <- PartitiontoDAG(results, scorer)

# Sample the edge probability.
SamplePosteriorPredictiveChains(dag_chains, function(dag) { return(dag) })

}
