% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shapeConstr.R, R/shapeConstr.default.R,
%   R/shapeConstr.factor.R
\name{shapeConstr}
\alias{shapeConstr}
\alias{shapeConstr.default}
\alias{shapeConstr.factor}
\title{Create shape constraints}
\usage{
shapeConstr(x, shape, ...)

\method{shapeConstr}{default}(x, shape, intercept = FALSE, ...)

\method{shapeConstr}{factor}(x, shape, intercept = FALSE, ...)
}
\arguments{
\item{x}{An object representing a design matrix of predictor variables, typically basis functions. See details for supported objects.}

\item{shape}{A character vector indicating one or several shape-constraints. See details for supported shapes.}

\item{...}{Additional parameters passed to or from other methods.}

\item{intercept}{For the default method, a logical value indicating if the design matrix includes an intercept. In most cases will be automatically extracted from \code{x}.}
}
\value{
A constraint matrix to be passed to \code{Cmat} in \link[=cirls.fit]{cirls.fit}.
}
\description{
Creates a constraint matrix to shape-constrain a set of coefficients. Mainly intended for splines but can constrain various bases or set of variables. Will typically be called from within \link[=cirls.fit]{cirls.fit} but can be used to generate constraint matrices.
}
\details{
The recommended usage is to directly specify the shape constraint through the \code{shape} argument in the call to \link[stats:glm]{glm} with \link[=cirls.fit]{cirls.fit}. This method is then called internally to create the constraint matrix. However, \code{shapeConstr} can nonetheless be called directly to manually build or inspect the constraint matrix for a given shape and design matrix.

The parameters necessary to build the constraint matrix (e.g. \code{knots} and \code{ord} for splines) are typically extracted from the \code{x} object. This is also true for the \code{intercept} for most of the object, except for the default method for which it can be useful to explicitly provide it. In a typical usage in which \code{shapeConstr} would only be called within \link[=cirls.fit]{cirls.fit}, \code{intercept} is automatically determined from the \link[stats:glm]{glm} formula.
\subsection{Allowed shapes}{

The \code{shape} argument allows to define a specific shape for the association between the expanded term in \code{x} and the response of the regression model. This shape can describe the relation between coefficients for the default method, or the shape of the smooth term for spline bases. At the moment, six different shapes are supported, with up to three allowed simultaneously (one from each category):
\itemize{
\item \code{"pos"} or \code{"neg"}: Positive/Negative. Applies to the full association.
\item \code{"inc"} or \code{"dec"}: Monotonically Increasing/Decreasing.
\item \code{"cvx"} or \code{"ccv"}: Convex/Concave.
}
}

\subsection{Available methods}{

In addition to the default method, \code{shapeConstr} currently supports several objects, creating an appropriate shape-constraint matrix depending on the object. The full list can be obtained by \code{methods(shapeConstr)}.
\subsection{General}{
\itemize{
\item \code{\link[=factor]{factor()}}: for categorical variables. Extract the \link[stats:contrasts]{contrasts} to define the constraint matrix. here the \code{intercept} argument has the same interpretation as in the default method, i.e. if set to \code{TRUE} it means the \code{glm} model doesn't include an intercept externally to the factor. Note that, in this case, a simple dummy coding is done in R.
}
}

\subsection{From the \link[splines:splines-package]{splines} package}{
\itemize{
\item \link[splines:bs]{bs}: B-splines.
\item \link[splines:ns]{ns}: Natural splines.
}
}

\subsection{From the \link[dlnm:dlnm-package]{dlnm} package}{
\itemize{
\item \link[dlnm:onebasis]{onebasis}: General method for basis functions generated in the package.
\item \link[dlnm:ps]{ps}: Penalised splines (P-Splines).
}
}

}
}
\examples{
# example code


}
\references{
Zhou, S. & Wolfe, D. A., 2000, On derivative estimation in spline regression. \emph{Statistica Sinica} \strong{10}, \strong{93–108}.
}
\seealso{
\code{\link[=cirls.fit]{cirls.fit()}} which typically calls \code{shapeConstr} internally.
}
