% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xAI.R
\name{conditionalEffects}
\alias{conditionalEffects}
\alias{conditionalEffects.citodnn}
\alias{conditionalEffects.citodnnBootstrap}
\title{Calculate average conditional effects}
\usage{
conditionalEffects(
  object,
  interactions = FALSE,
  epsilon = 0.1,
  device = c("cpu", "cuda", "mps"),
  indices = NULL,
  data = NULL,
  type = "response",
  ...
)

\method{conditionalEffects}{citodnn}(
  object,
  interactions = FALSE,
  epsilon = 0.1,
  device = c("cpu", "cuda", "mps"),
  indices = NULL,
  data = NULL,
  type = "response",
  ...
)

\method{conditionalEffects}{citodnnBootstrap}(
  object,
  interactions = FALSE,
  epsilon = 0.1,
  device = c("cpu", "cuda", "mps"),
  indices = NULL,
  data = NULL,
  type = "response",
  ...
)
}
\arguments{
\item{object}{object of class \code{citodnn}}

\item{interactions}{calculate interactions or not (computationally expensive)}

\item{epsilon}{difference used to calculate derivatives}

\item{device}{which device}

\item{indices}{of variables for which the ACE are calculated}

\item{data}{data which is used to calculate the ACE}

\item{type}{ACE on which scale (response or link)}

\item{...}{additional arguments that are passed to the predict function}
}
\value{
an S3 object of class \code{"conditionalEffects"} is returned.
The list consists of the following attributes:
\item{result}{3-dimensional array with the raw results}
\item{mean}{Matrix, average conditional effects}
\item{abs}{Matrix, summed absolute conditional effects}
\item{sd}{Matrix, standard deviation of the conditional effects}
}
\description{
Average conditional effects calculate the local derivatives for each observation for each feature. They are similar to marginal effects. And the average of these conditional effects is an approximation of linear effects (see Pichler and Hartig, 2023 for more details). You can use this function to either calculate main effects (on the diagonal, take a look at the example) or interaction effects (off-diagonals) between features.

To obtain uncertainties for these effects, enable the bootstrapping option in the \code{dnn(..)} function (see example).
}
\examples{
\donttest{
if(torch::torch_is_installed()){
library(cito)

# Build and train  Network
nn.fit = dnn(Sepal.Length~., data = datasets::iris)

# Calculate average conditional effects
ACE = conditionalEffects(nn.fit)

## Main effects (categorical features are not supported)
ACE

## With interaction effects:
ACE = conditionalEffects(nn.fit, interactions = TRUE)
## The off diagonal elements are the interaction effects
ACE[[1]]$mean
## ACE is a list, elements correspond to the number of response classes
## Sepal.length == 1 Response so we have only one
## list element in the ACE object

# Re-train NN with bootstrapping to obtain standard errors
nn.fit = dnn(Sepal.Length~., data = datasets::iris, bootstrap = 30L)
## The summary method calculates also the conditional effects, and if
## bootstrapping was used, it will also report standard errors and p-values:
summary(nn.fit)


}
}
}
\references{
Scholbeck, C. A., Casalicchio, G., Molnar, C., Bischl, B., & Heumann, C. (2022). Marginal effects for non-linear prediction functions. arXiv preprint arXiv:2201.08837.

Pichler, M., & Hartig, F. (2023). Can predictive models be used for causal inference?. arXiv preprint arXiv:2306.10551.
}
\author{
Maximilian Pichler
}
