% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{credentials_list}
\alias{credentials_list}
\title{List credentials}
\usage{
credentials_list(
  type = NULL,
  remote_host_id = NULL,
  default = NULL,
  system_credentials = NULL,
  users = NULL,
  name = NULL,
  limit = NULL,
  page_num = NULL,
  order = NULL,
  order_dir = NULL
)
}
\arguments{
\item{type}{string optional. The type (or types) of credentials to return. One or more of: Amazon Web Services S3, Bitbucket, CASS/NCOA PAF, Certificate, Civis Platform, Custom, Database, Google, Github, Salesforce User, Salesforce Client, and TableauUser. Specify multiple values as a comma-separated list (e.g., "A,B").}

\item{remote_host_id}{integer optional. The ID of the remote host associated with the credentials to return.}

\item{default}{boolean optional. If true, will return a list with a single credential which is the current user's default credential.}

\item{system_credentials}{boolean optional. If true, will only return system credentials. System credentials can only be created and viewed by Civis Admins.}

\item{users}{string optional. A comma-separated list of user ids. If specified, returns set of credentials owned by the users that requesting user has at least read access on.}

\item{name}{string optional. If specified, will be used to filter the credentials returned. Will search across name and will return any full name containing the search string.}

\item{limit}{integer optional. Number of results to return. Defaults to its maximum of 1000.}

\item{page_num}{integer optional. Page number of the results to return. Defaults to the first page, 1.}

\item{order}{string optional. The field on which to order the result set. Defaults to updated_at. Must be one of: updated_at, created_at, name.}

\item{order_dir}{string optional. Direction in which to sort, either asc (ascending) or desc (descending) defaulting to desc.}
}
\value{
An array containing the following fields:
\item{id}{integer, The ID of the credential.}
\item{name}{string, The name identifying the credential}
\item{type}{string, The credential's type.}
\item{username}{string, The username for the credential.}
\item{description}{string, A long description of the credential.}
\item{owner}{string, The username of the user who this credential belongs to. Using user.username is preferred.}
\item{user}{list, A list containing the following elements: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
\item{remoteHostId}{integer, The ID of the remote host associated with this credential.}
\item{remoteHostName}{string, The name of the remote host associated with this credential.}
\item{state}{string, The U.S. state for the credential. Only for VAN credentials.}
\item{createdAt}{string, The creation time for this credential.}
\item{updatedAt}{string, The last modification time for this credential.}
\item{default}{boolean, Whether or not the credential is a default. Only for Database credentials.}
\item{oauth}{boolean, Whether or not the credential is an OAuth credential.}
}
\description{
List credentials
}
