% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tag_create.R
\name{tag_create}
\alias{tag_create}
\title{Create a tag}
\usage{
tag_create(
  name,
  vocabulary_id,
  url = get_default_url(),
  key = get_default_key(),
  as = "list",
  ...
)
}
\arguments{
\item{name}{(character) The name for the new tag, a string between 2 and 100
characters long containing only alphanumeric characters and -, _ and .,
e.g. 'Jazz'}

\item{vocabulary_id}{(character) The id of the vocabulary that the new
tag should be added to, e.g. the id of vocabulary 'Genre'}

\item{url}{Base url to use. Default: https://data.ontario.ca/ See
also \code{\link{ckanr_setup}} and \code{\link{get_default_url}}.}

\item{key}{A privileged CKAN API key, Default: your key set with
\code{\link{ckanr_setup}}}

\item{as}{(character) One of list (default), table, or json. Parsing with
table option uses \code{jsonlite::fromJSON(..., simplifyDataFrame = TRUE)},
which attempts to parse data to data.frame's when possible, so the result
can vary from a vector, list or data.frame. (required)}

\item{...}{Curl args passed on to \code{\link[crul]{verb-POST}} (optional)}
}
\description{
IMPORTANT: You must be a sysadmin to create vocabulary tags.
}
\examples{
\dontrun{
ckanr_setup(url = "https://demo.ckan.org/",
  key = Sys.getenv("CKAN_DEMO_KEY"))
tag_create(name = "TestTag1", vocabulary_id = "Testing1")
}
}
