% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clc.R, R/clc_category.R, R/clc_raster.R
\name{get_colors.clc}
\alias{get_colors.clc}
\alias{get_colors}
\alias{get_colors.clc_category}
\alias{get_colors.clc_raster}
\title{Retrieve Colors from a CLC Style Definition}
\usage{
\method{get_colors}{clc}(clo)

get_colors(clo)

\method{get_colors}{clc_category}(clo)

\method{get_colors}{clc_raster}(clo)
}
\arguments{
\item{clo}{A `clc_category` object.}
}
\value{
A character vector of colors.
}
\description{
This function extracts the color values associated with a CLC style definition.
It returns a character vector containing the `color` field from the CLC style definition.
}
\examples{
source_gpkg <- system.file("extdata", "clc.gpkg", package = "clc")
clo <- clc(source = source_gpkg, layer_name = "clc")

levels <- clo |>
  get_colors()

}
\seealso{
Other CLC class functions: 
\code{\link{as_raster}()},
\code{\link{clc}()},
\code{\link{copy_to}()},
\code{\link{cut_to_extent}()},
\code{\link{get_levels.clc}()},
\code{\link{get_raster}()},
\code{\link{plot_clc}()},
\code{\link{prepare_plot}()},
\code{\link{save_to}()}
}
\concept{CLC class functions}
