% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rescale0to1.R
\name{rescale0to1}
\alias{rescale0to1}
\title{Rescale raster from 0 to 1}
\usage{
rescale0to1(rasterForCalculation)
}
\arguments{
\item{rasterForCalculation}{A `SpatRaster` that contains data to be rescaled}
}
\value{
A raster that has been rescaled from 0 to 1
}
\description{
A function to rescale a raster from 0 to 1. This is done using the formula (value-min)/(max-min).
}
\examples{
precipDeviation <- terra::rast(system.file("extdata/precipDeviation.asc",
                                           package = "climateStability"))
precipStability <- 1/precipDeviation
relativeClimateStability <- rescale0to1(precipStability)

}
\references{
Owens, H.L., Guralnick, R., 2019. climateStability: An R package to estimate
climate stability from time-slice climatologies. Biodiversity Informatics
14, 8–13. https://doi.org/10.17161/bi.v14i0.9786
}
\keyword{manip}
