% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Autocorrelation.R
\name{autocorr}
\alias{autocorr}
\title{Autocorrelation}
\usage{
autocorr(
  envrmt = .GlobalEnv$envrmt,
  method = "monthly",
  resp,
  pred,
  plot.corrplot = TRUE,
  corrplot = "coef"
)
}
\arguments{
\item{envrmt}{variable name of your envrmt list created using climodr's `envi.create` function. Default = envrmt.}

\item{method}{character. Choose the time scale your data is preserved in. Either "annual", "monthly" or "daily".}

\item{resp}{numerical. Vector or single input of the columns in the final.csv that contain your sensor data ("response variables"). The function will create one file per variable.}

\item{pred}{numerical. Vector or single input. The columns of your predictor variables, that you want to test for autocorrelation with the response variables.}

\item{plot.corrplot}{logical. Should correlation matrices be plotted?}

\item{corrplot}{character. Vector or single input. If plot.corrplot is true, you can choose the design of the correlation plot. You can choose from "coef", "crossout", "blank". Default is "coef".}
}
\value{
One .csv file per response variable. These will later be used when `autocorrelation` is set `TRUE` during `calc.model`.
}
\description{
Tests the final.csv created with `fin.csv` on autocorrelation to produce
reliable models.
}
\examples{
\donttest{
#create climodr environment and allow terra-functions to use 70\% of RAM
envrmt <- envi.create(proj_path = tempdir(),
                      memfrac = 0.7)

# Load the climodr example data into the current climodr environment
clim.sample(envrmt = envrmt)

#prepare csv-files
prep.csv(envrmt = envrmt,
         method = "proc",
         save_output = TRUE)

#process csv-files
csv_data <- proc.csv(envrmt = envrmt,
                     method = "monthly",
                     rbind = TRUE,
                     save_output = TRUE)

# Crop all raster bands
crop.all(envrmt = envrmt,
         method = "MB_Timeseries",
         overwrite = TRUE)

# Calculate Indices from cropped raster bands
calc.indices(envrmt = envrmt,
             vi = "all",
             bands = c("blue", "green", "red",
                       "nir", "nirb",
                       "re1", "re2", "re3",
                       "swir1", "swir2"),
             overwrite = TRUE)

#extract station coordinates
csv_spat <- spat.csv(envrmt = envrmt,
                     method = "monthly",
                     des_file = "plot_description.csv",
                     save_output = TRUE)


#extract predictor values from raster files
csv_fin <- fin.csv(envrmt = envrmt,
                   method = "monthly",
                   save_output = TRUE)

# Test data for autocorrelation after running fin.csv
autocorr(envrmt = envrmt,
         method = "monthly",
         resp = 5,
         pred = c(8:23),
         plot.corrplot = FALSE)
}

}
\seealso{
`calc.model`
}
