% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Prediction.R
\name{climpred}
\alias{climpred}
\title{Predict sensor data area wide}
\usage{
climpred(envrmt = .GlobalEnv$envrmt, method = "monthly", mnote, AOA = TRUE)
}
\arguments{
\item{envrmt}{variable name of your envrmt list created using climodr's `envi.create` function. Default = envrmt.}

\item{method}{Character. Either "daily", monthly" or "annual". Also depends on the available data.}

\item{mnote}{Character. Model note to filter models for the fitting model run.}

\item{AOA}{Logical. Should the Area of Applicability be calculated additional to the models?}
}
\value{
Multiple models.rds stored in the /workflow/models folder.
}
\description{
Use the models created using `calc.model` to predict the modeled data onto a
full spatial raster scene.
}
\examples{
\donttest{
#create climodr environment and allow terra-functions to use 70\% of RAM
envrmt <- envi.create(proj_path = tempdir(),
                      memfrac = 0.7)

# Load the climodr example data into the current climodr environment
clim.sample(envrmt = envrmt)

#prepare csv-files
prep.csv(envrmt = envrmt,
         method = "proc",
         save_output = TRUE)

#process csv-files
csv_data <- proc.csv(envrmt = envrmt,
                     method = "monthly",
                     rbind = TRUE,
                     save_output = TRUE)

# Crop all raster bands
crop.all(envrmt = envrmt,
         method = "MB_Timeseries",
         overwrite = TRUE)

# Calculate Indices from cropped raster bands
calc.indices(envrmt = envrmt,
             vi = "all",
             bands = c("blue", "green", "red",
                       "nir", "nirb",
                       "re1", "re2", "re3",
                       "swir1", "swir2"),
             overwrite = TRUE)

#extract station coordinates
csv_spat <- spat.csv(envrmt = envrmt,
                     method = "monthly",
                     des_file = "plot_description.csv",
                     save_output = TRUE)


#extract predictor values from raster files
csv_fin <- fin.csv(envrmt = envrmt,
                   method = "monthly",
                   save_output = TRUE)

# Test data for autocorrelation after running fin.csv
autocorr(envrmt = envrmt,
         method = "monthly",
         resp = 5,
         pred = c(8:23),
         plot.corrplot = FALSE)

# Create 36 different models (12 months x 3 classifiers) for every month in 2017
calc.model(envrmt = envrmt,
           method = "monthly",
           timespan = c(2017),
           climresp = 5,
           classifier = c("rf",
                          "pls",
                          "lm"),
           seed = 707,
           p = 0.8,
           folds = "LLO",
           mnote = "normal",
           predrows = c(8:23),
           tc_method = "cv",
           metric = "RMSE",
           autocorrelation = TRUE,
           doParallel = FALSE)

# Make predictions
climpred(envrmt = envrmt,
         method = "monthly",
         mnote = "normal",
         AOA = TRUE)

predlist <- list.files(envrmt$path_predictions,
                       pattern = ".tif")
head(predlist)
}

}
\seealso{
`autocorr`, `predict`
}
