\name{altitude_adjusted_perc}
\alias{altitude_adjusted_perc}
\title{
Altitude-Adjusted PERC Rule for Pulmonary Embolism
}
\description{
Applies the Pulmonary Embolism Rule-out Criteria (PERC) with an adjustment for high altitude. Standard PERC requires an oxygen saturation (SaO2) >= 95\%. The Altitude-Adjusted PERC lowers this threshold to >= 90\% to account for the physiological hypoxia associated with higher elevations, maintaining specificity while preventing unnecessary imaging.
}
\usage{
altitude_adjusted_perc(age, heart_rate, o2_sat, hemoptysis, estrogen_use,
                       surgery_trauma_4wks, prior_vte, unilateral_leg_swelling)
}
\arguments{
  \item{age}{
Numeric. Patient age in years. (Criteria met if < 50).
}
  \item{heart_rate}{
Numeric. Heart rate in bpm. (Criteria met if < 100).
}
  \item{o2_sat}{
Numeric. Oxygen saturation in \%. (Criteria met if >= 90\% for altitude adjustment; Standard is 95\%).
}
  \item{hemoptysis}{
Numeric (0 or 1). Presence of hemoptysis. (Criteria met if 0).
}
  \item{estrogen_use}{
Numeric (0 or 1). Exogenous estrogen use (OCPs, HRT, etc.). (Criteria met if 0).
}
  \item{surgery_trauma_4wks}{
Numeric (0 or 1). Recent surgery or trauma requiring hospitalization within 4 weeks. (Criteria met if 0).
}
  \item{prior_vte}{
Numeric (0 or 1). Prior history of DVT or PE. (Criteria met if 0).
}
  \item{unilateral_leg_swelling}{
Numeric (0 or 1). Unilateral leg swelling. (Criteria met if 0).
}
}
\value{
A list containing:
\item{Result}{"PERC Negative" (Rule Out) or "PERC Positive" (Cannot Rule Out).}
\item{Recommendation}{Guidance on the need for further testing (e.g., D-dimer).}
\item{Criteria_Violated}{List of specific criteria that failed the rule-out.}
}
\references{
Madsen T, et al. Prospective validation of the pulmonary embolism rule-out criteria at high altitude. Am J Emerg Med. 2020.
}
\examples{

# Example 1: Negative Rule Out (High Altitude Context)
# 45yo, HR 90, O2 91\% (Passes altitude cutoff), No other risks
altitude_adjusted_perc(45, 90, 91, 0, 0, 0, 0, 0)

# Example 2: Positive Rule Out (Fails O2)
# 45yo, HR 90, O2 88\% (Fails even adjusted cutoff)
altitude_adjusted_perc(45, 90, 88, 0, 0, 0, 0, 0)
}
