\name{cage_alcohol_screen}
\alias{cage_alcohol_screen}
\title{
CAGE Questions for Alcohol Use
}
\description{
Calculates the score for the CAGE questionnaire, a widely used screening tool for detecting alcohol dependence and abuse. The acronym is derived from the four questions: Cut down, Annoyed, Guilty, and Eye-opener. Two or more "Yes" answers typically indicate a positive screen requiring further assessment.
}
\usage{
cage_alcohol_screen(cut_down, annoyed, guilty, eye_opener)
}
\arguments{
  \item{cut_down}{
Numeric (0 or 1). Have you ever felt you should Cut down on your drinking? (1 = Yes).
}
  \item{annoyed}{
Numeric (0 or 1). Have people Annoyed you by criticizing your drinking? (1 = Yes).
}
  \item{guilty}{
Numeric (0 or 1). Have you ever felt bad or Guilty about your drinking? (1 = Yes).
}
  \item{eye_opener}{
Numeric (0 or 1). Have you ever had a drink first thing in the morning to steady your nerves or to get rid of a hangover (Eye-opener)? (1 = Yes).
}
}
\value{
A list containing:
\item{CAGE_Score}{The calculated total score (Range 0-4).}
\item{Screen_Result}{"Positive Screen" (Score >= 2) or "Negative Screen".}
\item{Interpretation}{Clinical guidance regarding the likelihood of alcohol dependence.}
}
\references{
Ewing JA. Detecting alcoholism. The CAGE questionnaire. JAMA. 1984;252(14):1905-1907. doi:10.1001/jama.252.14.1905
}
\examples{

# Example 1: Positive Screen
# Felt need to cut down (1), Annoyed by criticism (1), No guilt (0), No eye opener (0)
# Score = 2
cage_alcohol_screen(1, 1, 0, 0)

# Example 2: Negative Screen
# No affirmative answers
# Score = 0
cage_alcohol_screen(0, 0, 0, 0)
}
