\name{du_bois_ipf_score}
\alias{du_bois_ipf_score}
\title{
du Bois Score for Idiopathic Pulmonary Fibrosis (IPF) Mortality
}
\description{
Calculates the du Bois score to predict the 1-year risk of mortality in patients with Idiopathic Pulmonary Fibrosis (IPF). The score is based on age, history of respiratory hospitalization, baseline FVC, and the 24-week change in FVC.
}
\usage{
du_bois_ipf_score(age, history_resp_hospitalization, baseline_fvc_percent,
                  fvc_change_24wk_percent)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
< 60: 0 pts.
60-69: 4 pts.
>= 70: 8 pts.
}
  \item{history_resp_hospitalization}{
Numeric (0 or 1). History of respiratory hospitalization in the past 6 months. (1 = Yes, +14 pts).
}
  \item{baseline_fvc_percent}{
Numeric. Predicted baseline Forced Vital Capacity (FVC) percentage.
>= 80: 0 pts.
66-79: 8 pts.
51-65: 13 pts.
<= 50: 18 pts.
}
  \item{fvc_change_24wk_percent}{
Numeric. Change in predicted FVC over 24 weeks in percentage points. (e.g., -5 for a 5% decline).
>= -4.9: 0 pts (Stable/Improved).
-5 to -9.9: 10 pts (Marginal Decline).
<= -10: 21 pts (Significant Decline).
}
}
\value{
A list containing:
\item{du_Bois_Score}{The calculated risk score (Range 0-61).}
\item{Est_1_Year_Mortality}{Estimated probability of death within 1 year.}
}
\references{
du Bois RM, et al. Ascertainment of individual risk of mortality for patients with idiopathic pulmonary fibrosis. Am J Respir Crit Care Med. 2011;184(4):459-466. doi:10.1164/rccm.201011-1790OC
}
\examples{

# Example 1: High Risk
# 72yo (+8), Prior Hosp (+14), FVC 55% (+13), Decline -12% (+21)
# Score = 56
du_bois_ipf_score(72, 1, 55, -12)

# Example 2: Low Risk
# 55yo (0), No Hosp (0), FVC 85% (0), Stable FVC (0)
# Score = 0
du_bois_ipf_score(55, 0, 85, 0)
}
