\name{fibrotic_nash_index}
\alias{fibrotic_nash_index}
\title{
Fibrotic NASH Index (FNI)
}
\description{
Calculates the Fibrotic NASH Index (FNI) to predict the presence of advanced fibrosis in patients with Nonalcoholic Steatohepatitis (NASH). This simple index uses three common laboratory values: AST, HDL cholesterol, and HbA1c.
}
\usage{
fibrotic_nash_index(ast, hdl_cholesterol, hba1c)
}
\arguments{
  \item{ast}{
Numeric. Aspartate Aminotransferase level (U/L).
}
  \item{hdl_cholesterol}{
Numeric. High-Density Lipoprotein Cholesterol level (mg/dL).
}
  \item{hba1c}{
Numeric. Hemoglobin A1c percentage.
}
}
\value{
A list containing:
\item{FNI_Score}{The calculated risk score (probability between 0 and 1).}
\item{Risk_Category}{Classification (Low < 0.10, Intermediate 0.10-0.33, High > 0.33).}
\item{Interpretation}{Clinical meaning of the risk category.}
}
\references{
Loomba R, et al. Fibrotic NASH Index: A Simple Model to Predict Advanced Fibrosis in Patients With Nonalcoholic Steatohepatitis. Hepatology. 2019.
}
\examples{

# Example 1: High Risk
# AST 80, HDL 30, HbA1c 8.5
fibrotic_nash_index(80, 30, 8.5)

# Example 2: Low Risk
# AST 20, HDL 60, HbA1c 5.0
fibrotic_nash_index(20, 60, 5.0)
}
