\name{glasgow_coma_scale}
\alias{glasgow_coma_scale}
\title{
Glasgow Coma Scale (GCS)
}
\description{
Calculates the Glasgow Coma Scale score, a neurological scale used to assess the state of a person's consciousness. The scale is composed of three tests: eye, verbal, and motor responses. The total score values range from 3 (deep coma) to 15 (fully awake).
}
\usage{
glasgow_coma_scale(eye_response, verbal_response, motor_response)
}
\arguments{
  \item{eye_response}{
Numeric (1-4).
1: Does not open eyes.
2: Opens eyes in response to painful stimuli.
3: Opens eyes in response to voice.
4: Opens eyes spontaneously.
}
  \item{verbal_response}{
Numeric (1-5).
1: Makes no sounds.
2: Incomprehensible sounds.
3: Utters inappropriate words.
4: Confused, disoriented.
5: Oriented, converses normally.
}
  \item{motor_response}{
Numeric (1-6).
1: Makes no movements.
2: Extension to painful stimuli (decerebrate response).
3: Abnormal flexion to painful stimuli (decorticate response).
4: Flexion / Withdrawal to painful stimuli.
5: Localizes painful stimuli.
6: Obeys commands.
}
}
\value{
A list containing:
\item{GCS_Score}{The calculated total GCS score (Range 3-15).}
\item{Injury_Severity}{Classification (Mild 13-15, Moderate 9-12, Severe 3-8).}
\item{Clinical_Action}{General management guidance based on the score (e.g., intubation for GCS <= 8).}
}
\references{
Teasdale G, Jennett B. Assessment of coma and impaired consciousness. A practical scale. Lancet. 1974;2(7872):81-84. doi:10.1016/s0140-6736(74)91639-0
}
\examples{

# Example 1: Severe Injury
# Eye 1 (None), Verbal 2 (Sounds), Motor 4 (Withdrawal)
# Score = 7
glasgow_coma_scale(1, 2, 4)

# Example 2: Mild Injury
# Eye 4 (Spontaneous), Verbal 4 (Confused), Motor 6 (Obeys)
# Score = 14
glasgow_coma_scale(4, 4, 6)
}
