\name{nedocs_score}
\alias{nedocs_score}
\title{
NEDOCS Score for Emergency Department Overcrowding
}
\description{
Calculates the National Emergency Department Overcrowding Scale (NEDOCS) score. This tool quantifies the degree of overcrowding in an emergency department at a specific point in time using operational variables such as patient volume, bed capacity, and wait times.
}
\usage{
nedocs_score(total_patients_ed, total_ed_beds, admits_in_ed, total_hospital_beds,
             ventilated_patients_ed, longest_admit_time_hrs,
             wait_time_last_patient_hrs)
}
\arguments{
  \item{total_patients_ed}{
Numeric. Total number of patients currently in the ED (including those in beds, hallways, and the waiting room).
}
  \item{total_ed_beds}{
Numeric. Total number of licensed ED treatment beds.
}
  \item{admits_in_ed}{
Numeric. Number of patients in the ED admitted to the hospital but waiting for a bed.
}
  \item{total_hospital_beds}{
Numeric. Total number of licensed hospital beds.
}
  \item{ventilated_patients_ed}{
Numeric. Number of patients currently on ventilators in the ED.
}
  \item{longest_admit_time_hrs}{
Numeric. Time (in hours) the longest-waiting admitted patient has been in the ED.
}
  \item{wait_time_last_patient_hrs}{
Numeric. Waiting time (in hours) from arrival to bed placement for the last patient placed in a bed.
}
}
\value{
A list containing:
\item{NEDOCS_Score}{The calculated score (Range 0-200).}
\item{Status}{Classification of overcrowding severity (e.g., Not Busy, Overcrowded, Disaster).}
}
\references{
Weiss SJ, Derlet R, Arndahl J, et al. Estimating the degree of emergency department overcrowding in academic medical centers: results of the National ED Overcrowding Study (NEDOCS). Acad Emerg Med. 2004;11(1):38-50. doi:10.1197/j.aem.2003.07.017
}
\examples{

# Example 1: Busy ED
# 35 patients, 30 beds, 4 admits, 400 hospital beds, 0 vents, 4h wait admit, 1h last bed
# Score = -20 + 85.8(1.16) + 600(0.01) + 0 + 0.93(4) + 5.64(1) = ~95 (Overcrowded)
nedocs_score(35, 30, 4, 400, 0, 4, 1)

# Example 2: Disaster Level
# 60 patients, 30 beds, 15 admits, 400 hospital beds, 2 vents, 12h wait admit, 3h last bed
# Score = -20 + 85.8(2) + 600(0.0375) + 13.4(2) + 0.93(12) + 5.64(3) = ~229 -> Capped at 200
nedocs_score(60, 30, 15, 400, 2, 12, 3)
}
