% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curve-fit.R
\name{average_curve_lm}
\alias{average_curve_lm}
\title{Generate an average curve using \code{lm}}
\usage{
average_curve_lm(data, coupon_var, model, n_bins = 100)
}
\arguments{
\item{data}{a \code{data.frame}}

\item{coupon_var}{the variable for coupon identification}

\item{model}{a \code{formula} for the curve to fit}

\item{n_bins}{the number of bins to average the data inside into before
fitting}
}
\value{
an object of class \code{average_curve_lm} with the following content:
\itemize{
\item \code{data} the original data provided to the function
\item \code{binned_data} the data after the binning/averaging operation
\item \code{fit_lm} the results of the call to \code{lm}
\item \code{n_bins} the number of bins specified by the user
\item \code{max_x} the upper end of the range used for fitting
\item \code{y_var} the independent (\code{Y}) variable
\item \code{x_var} the dependent (\code{X}) variable
}
}
\description{
The user must decide on a single dependent variable (\code{Y}) and a
single independent variable (\code{X}). The user will specify a \code{formula} with
the relationship between the dependent and independent variables.
For a \code{data.frame} containing stress-strain (or load-deflection) data for
more than one coupon, the maximum value of \code{X} for each coupon is found and
the smallest maximum value determines the range over which the curve
fit is performed: the range is from zero to this value. Only positive
values of \code{X} are considered. For each coupon individually, the data is
divided into a user-specified number of bins and averaged within each bin.
The resulting binned/averaged data is then passed to \code{\link[stats:lm]{stats::lm()}} to perform
the curve fitting.
}
\details{
When specifying the formula (argument \code{model}), there are two things to
keep in mind. First, based on physical behavior, it is normally desirable
to set the intercept to zero (e.g. so that there is 0 stress at 0 strain).
To do this, include a term \code{+0} in the formula. Second, when specifying
a term for a power of the \code{X} variable (for example, $X^2$), this needs
to be wrapped inside the "as-is" operator \code{I()}, otherwise, \code{R} will
treat it as an interaction term, rather than an exponent. In other words,
if you want to include a quadratic term, you need to write \code{I(X^2)}
(replacing \code{X} with the appropriate variable from your \code{data.frame}).
}
\examples{
# using the `pa12_tension` dataset and fitting a cubic polynomial with
# zero intercept:
curve_fit <- average_curve_lm(
  pa12_tension,
  Coupon,
  Stress ~ I(Strain) + I(Strain^2) + I(Strain^3) + 0,
  n_bins = 100
)
print(curve_fit)
## Range: ` Strain ` in  [ 0,  0.1409409 ]
##
## Call:
##   average_curve_lm(data = pa12_tension, coupon_var = Coupon,
##                    model = Stress ~ I(Strain) + I(Strain^2) + I(Strain^3)
##                    + 0, n_bins = 100)
##
## Coefficients:
##    I(Strain)   I(Strain^2)   I(Strain^3)
##        1174         -8783         20586

}
\seealso{
\code{\link[base:tilde]{~}}, \code{\link[base:AsIs]{I()}}, \code{\link[stats:lm]{lm()}},
\code{\link[=average_curve_optim]{average_curve_optim()}}, \code{\link[=print.average_curve_lm]{print.average_curve_lm()}},
\code{\link[=summary.average_curve_lm]{summary.average_curve_lm()}}, \code{\link[=augment.average_curve_lm]{augment.average_curve_lm()}}
}
