% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cocron.two.coefficients.r
\name{cocron.two.coefficients}
\alias{cocron.two.coefficients}
\title{Statistical comparisons of two alpha coefficients}
\usage{
cocron.two.coefficients(alpha, n, dep = FALSE, r = NULL, los = 0.05,
  alternative = "two.sided")
}
\arguments{
\item{alpha}{A numeric vector containing the two alpha coefficients.}

\item{n}{A numeric vector containing the number of individuals who provided the data for the test for which alpha coefficients were determined.}

\item{dep}{A logical indicating whether alpha coefficients are based on dependent groups of individuals (default is \code{FALSE}).}

\item{r}{A single number specifying the correlation between the scores the alpha coefficients are based on. Only required if the alpha coefficients are computed for dependent groups of individuals (\code{dep = TRUE}).}

\item{los}{A number indicating the level of significance (default is \code{.05}).}

\item{alternative}{A character string specifying the alternative hypothesis; must be "\code{two.sided}" (default),
      "\code{greater}", or "\code{less}" (or just the initial letter).}
}
\value{
Returns an object of the class "\code{cocron.two.coefficients}" with the following slots:
\item{alpha}{Input parameter}
\item{n}{Input parameter}
\item{dep}{Input parameter}
\item{r}{Input parameter}
\item{los}{Input parameter}
\item{alternative}{Input parameter}
\item{statistic}{The value of the test statistic}
\item{distribution}{The distribution of the test statistic}
\item{df}{The degrees of freedom of the distribution of the test statistic}
\item{p.value}{The p-value of the test}
}
\description{
Performs a test of significance for the difference between two alpha coefficients (Cronbach,
      1951). The function expects alpha coefficients as input.
}
\details{
For comparing two dependent or independent alpha coefficients (Cronbach, 1951),
      the methods described in Charter and Feldt (1996) are available,
      which were originally introduced in Feldt (1969) and Feldt (1980).
}
\examples{

# independent alpha coefficients
cocron.two.coefficients(alpha=c(.78,.71), n=c(41,151), dep=FALSE)

# dependent alpha coefficients
cocron.two.coefficients(alpha=c(.82,.89), n=27,dep=TRUE, r=.74)

}
\references{
Cronbach,
      L. J. (1951). Coefficient alpha and the internal structure of tests. \emph{Psychometrika}, \emph{16}, 297-334.

Charter, R. A., & Feldt,
      L. S. (1996). Testing the equality of two alpha coefficients. \emph{Perceptual and Motor Skills}, \emph{82}, 763-768.

Feldt,
      L. S. (1969). A test of the hypothesis that Cronbach's alpha or Kuder-Richardson coefficient twenty is the same for two tests. \emph{Psychomelrika}, \emph{34}, 363-373.

Feldt,
      L. S. (1980). A test of the hypothesis that Cronbach's alpha reliability coefficient is the same for two tests administered to the same sample. \emph{Psychometrika},
      \emph{45}, 99-105.
}
\seealso{
\link{cocron}, \link{cocron.n.coefficients}
}

