% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cog_cat.R
\name{cog_cat}
\alias{cog_cat}
\title{Administer Cognitive Tests Using Computerized Adaptive Testing}
\usage{
cog_cat(rda = NULL, obj_fun = NULL, int_par = NULL)
}
\arguments{
\item{rda}{An RDA file (or list) containing y, kappa, gamma, lambda,
condition, omega_mu, omega_sigma2, zeta_mu, zeta_sigma2, nu_mu, and
nu_sigma2. y should be a 1 by IJ row vector. All items not administered
should have NA values in y. See package documentation for definitions and
dimensions of these other objects.}

\item{obj_fun}{A function that calculates predictions and log-likelihood
values for the selected model (character).}

\item{int_par}{Intentional parameters. That is, the parameters to optimize
precision (scalar).}
}
\value{
A list with elements for omega parameter estimates (omega1),
standard error of the estimates (se_omega), and the next condition to
administer (next_condition).
}
\description{
This function accepts an RDA file or a list containing selected objects and
returns omega estimates, the standard error of omega, and the optimal next
condition to administer for single-subject computerized adaptive testing.
Adaptive testing is guided by D-optimality (see Segall, 2009).
}
\examples{
rda = ex5
rda$y[which(!rda$condition \%in\% c(3))] <- NA
cog_cat(rda = rda, obj_fun = dich_response_model, int_par = 1)

}
\references{
Segall, D. O. (2009). Principles of Multidimensional Adaptive Testing. In W.
J. van der Linden & C. A. W. Glas (Eds.), \emph{Elements of Adaptive Testing}
 (pp. 57-75). https://doi.org/10.1007/978-0-387-85461-8_3
}
