% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identify_valid_variables.R
\name{identify_valid_variables}
\alias{identify_valid_variables}
\title{Find valid numeric, categorical, and logical variables in a dataframe}
\usage{
identify_valid_variables(
  df = NULL,
  responses = NULL,
  predictors = NULL,
  decimals = 4,
  quiet = FALSE,
  ...
)
}
\arguments{
\item{df}{(required; dataframe, tibble, or sf) A dataframe with responses
(optional) and predictors. Must have at least 10 rows for pairwise
correlation analysis, and \code{10 * (length(predictors) - 1)} for VIF.
Default: NULL.}

\item{responses}{(optional; character, character vector, or NULL) Name of
one or several response variables in \code{df}. Default: NULL.}

\item{predictors}{(required, character vector) Names of the predictors to identify. Default: NULL}

\item{decimals}{(required, integer) Number of decimal places for the zero variance test. Smaller numbers will increase the number of variables detected as near-zero variance. Recommended values will depend on the range of the numeric variables in 'df'. Default: 4}

\item{quiet}{(optional; logical) If FALSE, messages are printed. Default: FALSE.}

\item{...}{(optional) Internal args (e.g. \code{function_name} for
\code{\link{validate_arg_function_name}}, a precomputed correlation matrix
\code{m}, or cross-validation args for \code{\link{preference_order}}).}
}
\value{
list
\itemize{
\item \code{numeric}: character vector of numeric predictors.
\item \code{categorical}: character vector of categorical (character and factor) predictors.
\item \code{logical}: character vector of logical predictors.
}
}
\description{
Returns a list with the names of the valid numeric, categorical, and logical variables in a modelling dataframe.
}
\examples{

data(vi_smol, vi_predictors)

x <- identify_valid_variables(
  df = vi_smol,
  predictors = vi_predictors
)

x

}
\seealso{
Other data_types: 
\code{\link{identify_categorical_variables}()},
\code{\link{identify_logical_variables}()},
\code{\link{identify_numeric_variables}()},
\code{\link{identify_response_type}()},
\code{\link{identify_zero_variance_variables}()}
}
\author{
Blas M. Benito, PhD
}
\concept{data_types}
