% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcAComf.R
\name{calctAdapt15251}
\alias{calctAdapt15251}
\alias{calctadapt}
\alias{calctAdapt}
\alias{calctAdaptASHRAE}
\alias{calctnAuliciems}
\alias{calctnHumphreysNV}
\alias{calctnHumphreysAC}
\alias{tadapt}
\alias{tAdapt15251}
\alias{tAdaptASHRAE}
\alias{tnAuliciems}
\alias{tnHumphreysNV}
\alias{tnHumphreysAC}
\title{Adaptive Comfort or Neutral Temperatures}
\usage{
calctAdapt15251(trm = 20)

calctAdaptASHRAE(tmmo)

calctnAuliciems(ta, tmmo)

calctnHumphreysNV(tmmo)

calctnHumphreysAC(tmmo)
}
\arguments{
\item{trm}{numerical value presenting the running mean outdoor temperature in [degree C].}

\item{ta}{numerical value presenting the indoor air temperature in [degree C].}

\item{tmmo}{numerical value presenting the mean monthly outdoor temperature in [degree C].}
}
\value{
returns the adaptive comfort or neutral temperature with respect to the given outdoor temperature value
}
\description{
\code{calctadapt} are three functions to calculate adaptive comfort or neutral temperatures based on a given outdoor temperature value.
}
\note{
The difference between \code{calctnHumphreysNV} and \code{calctnHumphreysAC} is that the former was found for natural ventilated buildings (NV), while the latter was found for climate-controlled buildings (AC).
}
\examples{
## define variable
trm <- 21.2
## calculate adaptive comfort temperature
calctAdapt15251(trm)
}
\references{
\code{calctAdapt15251} is based on DIN EN 15251 Indoor environmental input parameters for design and assessment of energy performance of buildings addressing indoor air quality, thermal environment, lighting and acoustics; German version EN 15251:2012 2012.

\code{calcAdaptASHRAE} is based on Brager & de Dear (2001) Climate, comfort, & natural ventilation: a new adaptive comfort standard for ASHRAE standard 55.

\code{calctnAuliciems} is based on Auliciems (1981) Psycho-physiological criteria for global thermal zones of building design.

\code{calctnHumphreysNV} and \code{calctnHumphreysAC} are based on Humphreys (1978) Outdoor temperatures and comfort indoors. Batiment International, Building Research and Practice, Taylor and Francis.
}
\seealso{
see also \code{\link{calcComfInd}}
}
\author{
Code implemented in to R by Marcel Schweiker. Further contribution by Sophia Mueller and Shoaib Sarwar.
}
