% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitting.R
\name{polysolveLS}
\alias{polysolveLS}
\title{Polynomial Least Squares}
\usage{
polysolveLS(pts, m, tol = NULL)
}
\arguments{
\item{pts}{A \eqn{n \times 2} matrix or data frame where each row
contains the coordinates of a data point used for
regression.}

\item{m}{An integer. The degree of the polynomial to be used as
model for the regression.}

\item{tol}{A real number. The solution of a linear system can be
compromised when the condition number of the matrix of
coefficients is particularly high (ill-conditioned
matrices). \code{tol} is the reciprocal of the 
condition number. For values of tol smaller than 1e-17,
ill-conditioning is deemed to be sever enough not to
guarantee an accurate solution. For such values the
function stops execution, returning an error message.
In fact, the solution can still be accurate,
notwithstanding ill-conditioning, and the user can 
force the calculation of a solution using a value of
\code{tol} smaller than 1e-17. Default is \code{NULL},
corresponding to a \code{tol=1e-17}.}
}
\value{
A named list with two elements:
 \describe{
  \item{a}{A vector of length \eqn{m} containing the \eqn{m}
           numeric values of the estimated polynomial's
           coefficients.If more than one solution is possible,
           (infinite-solutions case) the function returns a
           \code{NULL} and prints out a related message.} 
 \item{SSE}{A real number. The numerical value of the sum of 
            squared residuals.}
}
}
\description{
Find the parameters, \eqn{a_1,\dots,a_{m+1}}, of the polynomial
model of degree \eqn{m} (1D function), using the least squares 
technique on a group of \eqn{n} data points.
}
\details{
The polynomial model has the following analytic form:
\deqn{
 y = a_1x^m + a_2x^{m-1} + \dots + a_mx + a_{m+1} 
}
The \eqn{n} data points are contained in a matrix or data frame 
with \eqn{2} columns, containing the coordinates of each data
point, and \eqn{n} rows. The least squares procedure is carried 
out as solution of a matrix equation, via the 
\code{\link{solveLS}} function.
}
\examples{
# 21 points close to the quadratic x^2 - 5*x + 6
x <- seq(-2,5,length=21)
set.seed(7766)
eps <- rnorm(21,mean=0,sd=0.5)
y <- x^2-5*x+6+eps

# Data frame
pts <- data.frame(x=x,y=y)

# Regression
ltmp <- polysolveLS(pts,m=2)
print(names(ltmp))
print(ltmp$a)
print(ltmp$SSE)

}
