% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformers.R
\name{penalty_l2}
\alias{penalty_l2}
\title{L2 penalty function (Ridge)}
\usage{
penalty_l2(weights = NULL)
}
\arguments{
\item{weights}{Optional parameter weights (default: all 1)}
}
\value{
Penalty function
}
\description{
Creates a penalty function that computes the L2 norm squared (sum of squares).
Used for parameter shrinkage.
}
\examples{
penalty <- penalty_l2()
penalty(c(1, -2, 3))  # Returns 14

# Weighted L2
penalty <- penalty_l2(weights = c(1, 2, 1))
penalty(c(1, -2, 3))  # Returns 1^2 + (2*2)^2 + 3^2 = 26
}
