% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trialDesignFns.R
\name{getBoundsFromConfidence}
\alias{getBoundsFromConfidence}
\title{Get Critical Bounds from Confidence Thresholds}
\usage{
getBoundsFromConfidence(
  num.treat.arms = 2,
  conf.lower = 0.01,
  conf.upper = 0.99,
  p.sided = 1
)
}
\arguments{
\item{num.treat.arms}{Number of treatment arms (excludes control). Default is 2.}

\item{conf.lower}{Confidence in treatment benefit boundary for inferiority i.e. stop for inferiority if confidence in benefit is below this.
Default is 0.01.}

\item{conf.upper}{Confidence in treatment benefit boundary for efficacy i.e. stop for efficacy if confidence in benefit is above this.
Default is 0.99.}

\item{p.sided}{Sidedness of statistical test, 1 (one-sided) and 2 (two-sided). Default is 1.}
}
\value{
List of values:
\itemize{
\item{conf.lower: confidence in treatment benefit lower bound}
\item{z.score.lower: critical value corresponding to lower confidence bound}
\item{p.value.lower: p-value correponding to lower confidence bound}
\item{conf.upper: confidence in treatment benefit upper bound}
\item{z.score.upper: critical value corresponding to upper confidence bound}
\item{p.value.upper: p-value corresponding to upper confidence bound}
\item{p.value: sidedness of test}
}
}
\description{
Derive traditional frequentist critical values from frequentist confidence thresholds for confidence in treatment benefit.
}
\details{
During a confidence trial, efficacy and inferiority is determined by the level of confidence in treatment benefit.
Efficacy is declared if this confidence level exceeds a pre-specified boundary,
and inferiority is declared if this confidence levels falls below a second pre-specified valye.
Given confidence-based thresholds for efficacy and inferiority, and the
sidedness of the test, this function returns the traditional frequentist p-value.
}
\examples{
# Running the function on default values
bounds <- getBoundsFromConfidence()

# to make adjustments for multiple arms
bounds <- getBoundsFromConfidence(num.treat.arms = 3)
}
