% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_result_list.R
\name{plot_interpretation_result_list}
\alias{plot_interpretation_result_list}
\title{Plotting function for collection of interpretation_result objects}
\usage{
plot_interpretation_result_list(x, extra_boundaries = NULL,
  estimates = NULL, boundary_values = TRUE, boundary_label_pos = "below",
  interpretation_label_pos = "right", x_axis_pos = "below",
  y_axis_pos = "none", inner_margin = c(-0.1, 0.05, -0.1, 0.05),
  edge_margin = c(0, 0.02, 0, 0.02), edge_type = "gradient",
  interval_type = "norm", y_scale = 0.75, interval_value_labels = TRUE,
  estimate_value_labels = TRUE, plot_estimate_marks = TRUE, ...)
}
\arguments{
\item{x}{A list of \code{interpretation_result} objects, length at least 2. The
objects may optionally be named. See Details.}

\item{extra_boundaries}{Names optional.}

\item{estimates}{Estimate values that the intervals assessed in each
\code{interpretation_result} object relate to. If not specified, a default
of the central point between the two ends of each interval will be assumed.}

\item{boundary_values}{A logical value indicating whether the values should be appended to
the boundaries' names.}

\item{boundary_label_pos}{Where to put the boundary labels.
Options are \code{c("below", "above", "on top", "none")}.
If you are planning to plot values on the canvas and want the boundary
labels on top then you may want to choose "none" and make a call to
\code{label_ontop_boundaries()} after plotting values.}

\item{interpretation_label_pos}{Options are \code{c("right", "left", "none")}}

\item{x_axis_pos}{Location of a numerical x axis.
Options are \code{c("none", "below", "above")}.}

\item{y_axis_pos}{Location of a numerical y axis. Default "none" will almost always be right.
Options are c\code{("none", "left", "right")}.}

\item{inner_margin}{Numerical vector of the form \code{c(bottom, left, top, right)}, which
gives the amount of inner margin to be added, expressed as a proportion
of the plotted area. This is space designed to be past any plotted objects
but before the edging (defined separately via \code{edge_margin}).
See Details.}

\item{edge_margin}{Numerical vector of the form \code{c(bottom, left, top, right)}, which gives
the amount of 'edge margin' to be added, expressed as a proportion of the
plotted width. This is the space designed to be occupied by plot edges
(e.g. a gradient fading out). Currently only implemented for left and
right; top and bottom values are ignored. See Details.}

\item{edge_type}{What style of edge to draw at the sides of the plot. Currently supported
options are \code{"gradient"} (the default) and \code{"zigzag"}.}

\item{interval_type}{Set the way the interval is presented. Current options are
\code{c("norm", "unif")} for a normal distribution-based curve
and a box, respectively.}

\item{y_scale}{How tall the interval plots are to be drawn}

\item{interval_value_labels}{Logical value specifying whether interval value labels are to be added.}

\item{estimate_value_labels}{Logical value specifying whether estimate value labels are to be added.}

\item{plot_estimate_marks}{Whether to plot marks at the x location of the estimates.}

\item{...}{Further arguments passed to and from methods.}
}
\description{
Produces a plot presenting a collection of
\code{\link{interpretation_result}}
objects on a single chart. If the \code{interpretation_result} objects are
named then the names will be used for labelling the relevant intervals on
the chart.
}
\details{
For a single \code{interpretation_result} object a \code{plot()} method is
provided; see \code{\link{plot.interpretation_result}}.

To be a valid group of \code{interpretation_result} objects, each of the
items in \code{x} must be a valid \code{interpretation_result}, and they
must all share some characteristics. Each of the component objects must have
been generated using the same \code{interpretation_set}, with the same
boundaries, and the \code{low_to_high} parameter must be the same. This
enables them to be meaningfully plotted on the same canvas.
}
\examples{

# Set up some intervals to test:
ci_stage_1 <- matrix(c(0.023, 0.131), nrow = 1,
                     dimnames = list("estimate", c("2.5 \%", "97.5 \%")))
ci_stage_2 <- matrix(c(-0.016, 0.096), nrow = 1,
                     dimnames = list("estimate", c("2.5 \%", "97.5 \%")))
# Conduct the interpretations:
interp_stage_1 <-  interpret_noninferiority(ci_stage_1, actual_null = 0,
                                           ni_margin = 0.05,
                                           groups = c("Business as usual",
                                                      "New approach"))
interp_stage_2 <-  interpret_noninferiority(ci_stage_2, actual_null = 0,
                                           ni_margin = 0.05,
                                           groups = c("Business as usual",
                                                      "New approach"))

# Assemble the list object:
interp_1_and_2 <- list("Stage 1" = interp_stage_1,
                       "Stage 2" = interp_stage_2)
# Set a nice colour scheme
grDevices::palette(c("#FF671F99", "#F2A90099", "#0085CA99"))
plot_interpretation_result_list(interp_1_and_2,
                                boundary_label_pos = "on top")

}
