% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split.R
\name{conformal.multidim.split}
\alias{conformal.multidim.split}
\title{Split conformal prediction intervals with Multivariate Response}
\usage{
conformal.multidim.split(
  x,
  y,
  x0,
  train.fun,
  predict.fun,
  alpha = 0.1,
  split = NULL,
  seed = FALSE,
  randomized = FALSE,
  seed_tau = FALSE,
  verbose = FALSE,
  training_size = 0.5,
  score = "l2",
  s_type = "st-dev",
  mad.train.fun = NULL,
  mad.predict.fun = NULL
)
}
\arguments{
\item{x}{The feature variables, a matrix n x p.}

\item{y}{The matrix of multivariate responses (dimension n x q)}

\item{x0}{The new points to evaluate, a matrix of dimension n0 x p.}

\item{train.fun}{A function to perform model training, i.e., to produce an
estimator of E(Y|X), the conditional expectation of the response variable
Y given features X. Its input arguments should be x: matrix of features,
and y: matrix of responses.}

\item{predict.fun}{A function to perform prediction for the (mean of the)
responses at new feature values. Its input arguments should be out: output
produced by train.fun, and newx: feature values at which we want to make
predictions.}

\item{alpha}{Miscoverage level for the prediction intervals, i.e., intervals
with coverage 1-alpha are formed. Default for alpha is 0.1.}

\item{split}{Indices that define the data-split to be used (i.e., the indices
define the first half of the data-split, on which the model is trained).
Default is NULL, in which case the split is chosen randomly.}

\item{seed}{Integer to be passed to set.seed before defining the random
data-split to be used. Default is FALSE, which effectively sets no seed.
If both split and seed are passed, the former takes priority and the latter
is ignored.}

\item{randomized}{Should the randomized approach be used? Default is FALSE.}

\item{seed_tau}{The seed for the randomized version. Default is FALSE.}

\item{verbose}{Should intermediate progress be printed out? Default is FALSE.}

\item{training_size}{Split proportion between training and calibration set.
Default is 0.5.}

\item{score}{The non-conformity measure. It can either be "max", "l2", "mahalanobis".
The default is "l2".}

\item{s_type}{The type of modulation function.
Currently we have 3 options: "identity","st-dev","alpha-max". Default is "st-dev"}

\item{mad.train.fun}{A function to perform training on the absolute residuals
i.e., to produce an estimator of E(R|X) where R is the absolute residual
R = |Y - m(X)|, and m denotes the estimator produced by train.fun.
This is used to scale the conformal score, to produce a prediction interval
with varying local width. The input arguments to mad.train.fun should be
x: matrix of features, y: vector of absolute residuals, and out: the output
produced by a previous call to mad.train.fun, at the \emph{same} features
x. The function mad.train.fun may (optionally) leverage this returned
output for efficiency purposes. See details below. The default for
mad.train.fun is NULL, which means that no training is done on the absolute
residuals, and the usual (unscaled) conformal score is used. Note that if
mad.train.fun is non-NULL, then so must be mad.predict.fun (next).}

\item{mad.predict.fun}{A function to perform prediction for the (mean of the)
absolute residuals at new feature values. Its input arguments should be
out: output produced by mad.train.fun, and newx: feature values at which we
want to make predictions. The default for mad.predict.fun is NULL, which
means that no local scaling is done for the conformal score, i.e., the
usual (unscaled) conformal score is used.}
}
\value{
A list with the following components: x0,pred,k_s,s_type,s,alpha,randomized,tau,
  average_width,lo,up. In particular pred, lo, up are the matrices of
  dimension n0 x q, k_s is a scalar, s_type is a string, s is a vector of length q,
  alpha is a scalar between 0 and 1, randomized is a logical value,
  tau is a scalar between 0 and 1,and average_width is a positive scalar.
}
\description{
Compute prediction intervals using split conformal inference with multivariate
response.
}
\details{
If the two mad functions are provided they take precedence over the s_type parameter,
and they force a local scoring via the mad function predicted values.
}
\examples{

sample_size=98

my_grid <- seq(from=0,to=1,length.out=5)
mu <- c(0,0,0)
sigma <- rbind(c(1,0.6,0.6), c(0.6,1,0.6), c(0.6,0.6,1))
mltvnorm3 <- mvtnorm::rmvnorm(sample_size, mu, sigma)
y=t(apply(mltvnorm3,1,function(x) x[1] + x[2]*cos(6*pi*my_grid) + x[3]*sin(6*pi*my_grid)))
x=mltvnorm3 + mvtnorm::rmvt(sample_size, diag(length(mu)))## add noise

n0=10
x0 = mvtnorm::rmvt(n0, diag(length(mu)))

fun=mean_multi()
fun=lm_multi()
fun=elastic.funs()


############################## SPLIT CONFORMAL


final.point = conformal.multidim.split(x,y[,1:2],x0[1:10,], fun$train.fun, fun$predict.fun,
                             alpha=0.1,
                                split=NULL, seed=FALSE, randomized=FALSE,seed_tau=FALSE,
                                verbose=FALSE, training_size=0.5,score ="l2",s_type="st-dev")

ppp2<-plot_multidim(final.point)
}
\references{
The s_regression and the "max" score are taken from "Conformal Prediction Bands
for Multivariate Functional Data" by Diquigiovanni, Fontana, Vantini (2021).
}
\seealso{
\code{\link{conformal.multidim.full}}
}
