% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/member.R
\name{cong_member}
\alias{cong_member}
\title{Request Member Information}
\usage{
cong_member(
  bioguide = NULL,
  item = NULL,
  congress = NULL,
  state = NULL,
  district = NULL,
  current_member = FALSE,
  from_date = NULL,
  to_date = NULL,
  limit = 20,
  offset = 0,
  format = "json",
  clean = TRUE
)
}
\arguments{
\item{bioguide}{Bioguide identifier for a member of Congress.}

\item{item}{Information to request. Can be \code{'sponsored-legislation'} or  \code{'cosponsored-legislation'}}

\item{congress}{Congress number.}

\item{state}{State abbreviation. e.g. \code{'CA'}.}

\item{district}{Congressional district number. e.g. \code{1}.}

\item{current_member}{Logical. Should only current members be returned? Default is \code{FALSE}.}

\item{from_date}{start date for search, e.g. \code{'2022-04-01'}. Defaults to most recent.}

\item{to_date}{end date for search, e.g. \code{'2022-04-03'}. Defaults to most recent.}

\item{limit}{number of records to return. Default is 20. Will be truncated to between 1 and 250.}

\item{offset}{number of records to skip. Default is 0. Must be non-negative.}

\item{format}{Output format for \code{clean = FALSE}. One of \code{xml} or \code{json}.}

\item{clean}{Default is TRUE. Should output be returned as a \code{tibble} (\code{TRUE}) or requested \code{format}.}
}
\value{
a \code{tibble::tibble} or HTTP response if \code{clean = FALSE}
}
\description{
This provides three search paths under the \verb{/member} endpoint.
\enumerate{
\item By \code{bioguide}, which can be subset with \code{item}
\item By \code{congress}, which can be subset with \code{state} and \code{district}
\item By \code{state}, which can be subset with \code{district}
}
}
\details{
If an invalid set of these are provided, they will be used in the above order.
}
\examples{
\dontshow{if (congress::has_congress_key()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Requires API Key

cong_member()

cong_member(bioguide = 'L000174')

cong_member(bioguide = 'L000174', item = 'sponsored-legislation')

cong_member(congress = 118)

cong_member(congress = 118, state = 'CA')

cong_member(congress = 118, state = 'CA', district = 1)

cong_member(state = 'MI', district = 2)
\dontshow{\}) # examplesIf}
}
