% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constellate_criteria.R
\name{constellate_criteria}
\alias{constellate_criteria}
\title{Provide details about individual events within a constellation}
\usage{
constellate_criteria(..., criteria_names, window_hours, join_key, time_var,
  value = c("boolean", "time", "result"), result_var = NULL)
}
\arguments{
\item{...}{An arbitrary number of time series data frames that each include
the columns 'join_key' and 'time_var'}

\item{criteria_names}{A vector of strings specifying the name of each
event. The order of strings in the vector should align with the order of
data frames passed in '...'.}

\item{window_hours}{A single numeric or vector of numerics specifying the
number of hours to search for each event. The order of numerics in the
vector should align with the order of data frames passed in '...'.}

\item{join_key}{A string name of the column to join all time series data
frames}

\item{time_var}{A string name of the time stamp column in all time series
data frames. The class of time_var must be POSIXct in all data frames.}

\item{value}{A string specifying the value to be entered within each
criteria column. Options include boolean (0 or 1, depdending on whether
the criteria event occurred), the time of the criteria event, or the
result stored within the criteria event. The default value is boolean.}

\item{result_var}{A string name of the value variable in all data frames.
This argument should only be supplied if the "result" option is selected
in the value argument.}
}
\value{
A data.frame, data.table with indicator variables for each event.
 The total number of rows is the unique number of time stamps for
 all combined measurements.
}
\description{
A function that reads in multiple time series data frames for various events
 and builds indicator variables for each event. Individual events that occur
 within a specified number from a timestamp are flagged. The variables for
 each event can be populated with the time the event took place, a boolean
 variable (0 or 1) indicating whether or not the event took place, or the
 result of the variable at the time the event took place.
}
\details{
The user passes an arbitrary number of time series data frames and
 specifies a name and number of hours to search for each event. The user
 must also specify a variable to use to join the tables, and the time stamp
 variable. The timestamps variable in every data frame must be POSIXct
 class. Finally, the user selects how to populate the individual event
 variables.

This function extends the constellate function to address a different set
 of questions, including: 1) at a specific timestamp, which events do and do
 not occur? 2) what is the sequence of events that trigger the constellation
 of events that I'm interested in? 3) What are the results of each criteria
 at the times that each criteria are met?
This function can be used to calculate risk scores at any measurement
 timestamp by building a new variable after the function runs and returns
 the new data frame. The risk score can add up the crieteria from boolean
 values (e.g.
 \href{https://www.mdcalc.com/sirs-sepsis-septic-shock-criteria}{SIRS Criteria})
 or can be a linear combination of criteria (e.g.,
 \href{https://www.mdcalc.com/national-early-warning-score-news}{NEWS Score}).
}
\section{Imported functions}{

general data.table syntax
}

\section{Errors}{

This function returns errors for:
\itemize{
 \item missing arguments (value has a default argument and result_var is
   missing by default)
 \item passing a window_hours value that is not numeric
 \item passing join_key or time_var values that are not column names in all
   time series data frames
 \item passing an invalid number of criteria_names (must be equal to number
   of criteria event data frames)
 \item passing an invalid number of window_hours values (1 or the number of
   criteria event data frames).
}
}

\examples{
library(data.table)
temp <- as.data.table(vitals[VARIABLE == "TEMPERATURE"])
pulse <- as.data.table(vitals[VARIABLE == "PULSE"])
resp <- as.data.table(vitals[VARIABLE == "RESPIRATORY_RATE"])

temp[, RECORDED_TIME := as.POSIXct(RECORDED_TIME,
  format = "\%Y-\%m-\%dT\%H:\%M:\%SZ", tz = "UTC")]
pulse[, RECORDED_TIME := as.POSIXct(RECORDED_TIME,
  format = "\%Y-\%m-\%dT\%H:\%M:\%SZ", tz = "UTC")]
resp[, RECORDED_TIME := as.POSIXct(RECORDED_TIME,
  format = "\%Y-\%m-\%dT\%H:\%M:\%SZ", tz = "UTC")]

# Pass single window_hours
constellate_criteria(temp, pulse, resp, criteria_names = c("TEMPERATURE",
 "PULSE", "RESPIRATORY_RATE"), window_hours = 6, join_key = "PAT_ID",
 time_var = "RECORDED_TIME", value = "time")
# Pass vector for window_hours
constellate_criteria(temp, pulse, resp, criteria_names = c("TEMPERATURE",
 "PULSE", "RESPIRATORY_RATE"), window_hours = c(6,6,6), join_key = "PAT_ID",
 time_var = "RECORDED_TIME", value = "time")
# Show the value of each criteria at the time the event occurs
constellate_criteria(temp, pulse, resp, criteria_names = c("TEMPERATURE",
 "PULSE", "RESPIRATORY_RATE"), window_hours = c(6,6,6), join_key =
 "PAT_ID", time_var = "RECORDED_TIME", value = "result",
 result_var = "VALUE")

}
