% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0-IteratorR6.R
\docType{class}
\name{Iterator}
\alias{Iterator}
\title{Iterator Class}
\description{
An \code{Iterator} is an object that allows to iterate over
sequences. It implements \code{next_iter} and \code{get_value} to iterate and
retrieve the value of the sequence it is associated with.
For the standard S3 interface, see \code{\link[=iter]{iter()}}.
}
\examples{

# Numeric Vector
v = 1:3
it = Iterator$new(v)
it

try(it$get_value())  # iterator does not point at a value

it$has_value()
it$has_next()
it$next_iter()
it$get_value()
it$get_next()
it$get_next()
it
it$has_next()
it$begin()
it$get_value()
it$reset_iter()

# Works by reference for Container
co = Container$new(1, 2, 3)
it = co$iter()
it$get_next()
co$discard(2)
it
it$get_value()
co$discard(1)
it
it$get_value()
it$begin()
}
\author{
Roman Pahl
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Iterator-new}{\code{Iterator$new()}}
\item \href{#method-Iterator-begin}{\code{Iterator$begin()}}
\item \href{#method-Iterator-get_value}{\code{Iterator$get_value()}}
\item \href{#method-Iterator-get_next}{\code{Iterator$get_next()}}
\item \href{#method-Iterator-has_next}{\code{Iterator$has_next()}}
\item \href{#method-Iterator-has_value}{\code{Iterator$has_value()}}
\item \href{#method-Iterator-length}{\code{Iterator$length()}}
\item \href{#method-Iterator-pos}{\code{Iterator$pos()}}
\item \href{#method-Iterator-next_iter}{\code{Iterator$next_iter()}}
\item \href{#method-Iterator-print}{\code{Iterator$print()}}
\item \href{#method-Iterator-reset_iter}{\code{Iterator$reset_iter()}}
\item \href{#method-Iterator-clone}{\code{Iterator$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Iterator-new"></a>}}
\if{latex}{\out{\hypertarget{method-Iterator-new}{}}}
\subsection{Method \code{new()}}{
\code{Iterator} constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Iterator$new(x, .subset = .subset2)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{object to iterate over}

\item{\code{.subset}}{accessor function}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
invisibly returns the \code{Iterator} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Iterator-begin"></a>}}
\if{latex}{\out{\hypertarget{method-Iterator-begin}{}}}
\subsection{Method \code{begin()}}{
set iterator to the first element of the underlying
sequence unless length of sequence is zero, in which case it will
point to nothing.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Iterator$begin()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
invisibly returns the \code{Iterator} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Iterator-get_value"></a>}}
\if{latex}{\out{\hypertarget{method-Iterator-get_value}{}}}
\subsection{Method \code{get_value()}}{
get value where the iterator points to
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Iterator$get_value()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
returns the value the \code{Iterator} is pointing at.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Iterator-get_next"></a>}}
\if{latex}{\out{\hypertarget{method-Iterator-get_next}{}}}
\subsection{Method \code{get_next()}}{
get next value
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Iterator$get_next()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
increments the iterator and returns the value the \code{Iterator}
is pointing to.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Iterator-has_next"></a>}}
\if{latex}{\out{\hypertarget{method-Iterator-has_next}{}}}
\subsection{Method \code{has_next()}}{
check if \code{iterator} has more elements
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Iterator$has_next()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{TRUE} if \code{iterator} has next element else \code{FALSE}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Iterator-has_value"></a>}}
\if{latex}{\out{\hypertarget{method-Iterator-has_value}{}}}
\subsection{Method \code{has_value()}}{
check if \code{iterator} points at value
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Iterator$has_value()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{TRUE} if \code{iterator} points at value otherwise \code{FALSE}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Iterator-length"></a>}}
\if{latex}{\out{\hypertarget{method-Iterator-length}{}}}
\subsection{Method \code{length()}}{
iterator length
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Iterator$length()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
number of elements to iterate
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Iterator-pos"></a>}}
\if{latex}{\out{\hypertarget{method-Iterator-pos}{}}}
\subsection{Method \code{pos()}}{
get iterator position
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Iterator$pos()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{integer} if \code{iterator} has next element else \code{FALSE}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Iterator-next_iter"></a>}}
\if{latex}{\out{\hypertarget{method-Iterator-next_iter}{}}}
\subsection{Method \code{next_iter()}}{
increment \code{iterator}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Iterator$next_iter()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
invisibly returns the \code{Iterator} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Iterator-print"></a>}}
\if{latex}{\out{\hypertarget{method-Iterator-print}{}}}
\subsection{Method \code{print()}}{
print method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Iterator$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Iterator-reset_iter"></a>}}
\if{latex}{\out{\hypertarget{method-Iterator-reset_iter}{}}}
\subsection{Method \code{reset_iter()}}{
reset iterator to '0'
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Iterator$reset_iter()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
invisibly returns the \code{Iterator} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Iterator-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Iterator-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Iterator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
